/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MergeLists<T> {
    Collection<Collection<T>> source = new ArrayList<Collection<T>>();
    Set<T> orderedWorkingSet;

    public MergeLists() {
        this(new LinkedHashSet());
    }

    public MergeLists(Set<T> orderedWorkingSet) {
        this.orderedWorkingSet = orderedWorkingSet;
    }

    public MergeLists<T> add(Collection<T> orderedItems) {
        if (orderedItems.size() == 0) {
            return this;
        }
        LinkedHashSet<T> linkedHashSet = new LinkedHashSet<T>(orderedItems);
        if (linkedHashSet.size() != orderedItems.size()) {
            throw new IllegalArgumentException("Multiple items in ordering!");
        }
        this.source.add(linkedHashSet);
        return this;
    }

    public MergeLists<T> add(T ... stuff) {
        return this.add((Collection<T>)Arrays.asList(stuff));
    }

    public MergeLists<T> addAll(Collection<Collection<T>> collectionsOfOrderedItems) {
        for (Collection<T> orderedItems : collectionsOfOrderedItems) {
            this.add(orderedItems);
        }
        return this;
    }

    public List<T> merge() {
        ArrayList<T> result = new ArrayList<T>();
        for (Collection<T> sublist : this.source) {
            this.orderedWorkingSet.addAll(sublist);
        }
        LinkedHashSet first = new LinkedHashSet();
        while (this.orderedWorkingSet.size() != 0) {
            this.getFirsts(first);
            if (first.size() == 0) {
                LinkedHashMap reasons = new LinkedHashMap();
                this.getFirsts(first, reasons);
                throw new IllegalArgumentException("Inconsistent requested ordering: cannot merge if we have [...A...B...] and [...B...A...]: " + String.valueOf(reasons));
            }
            T best = this.extractFirstOk(this.orderedWorkingSet, first);
            this.removeFromSource(best);
            result.add(best);
        }
        return result;
    }

    public static <T> boolean hasConsistentOrder(Collection<T> a, Collection<T> b) {
        LinkedHashSet<T> remainder = new LinkedHashSet<T>(a);
        remainder.retainAll(b);
        if (remainder.size() == 0) {
            return true;
        }
        Iterator<T> bi = b.iterator();
        T current = bi.next();
        for (Object item : remainder) {
            if (!item.equals(current)) continue;
            if (!bi.hasNext()) {
                return true;
            }
            current = bi.next();
        }
        return !bi.hasNext();
    }

    public static <T> Collection<T> hasConsistentOrderWithEachOf(Collection<T> a, Collection<Collection<T>> bs) {
        for (Collection<T> b : bs) {
            if (MergeLists.hasConsistentOrder(a, b)) continue;
            return b;
        }
        return null;
    }

    private void removeFromSource(T item) {
        Iterator<Collection<T>> iterator = this.source.iterator();
        while (iterator.hasNext()) {
            Collection<T> sublist = iterator.next();
            sublist.remove(item);
            if (sublist.size() != 0) continue;
            iterator.remove();
        }
    }

    private T extractFirstOk(Collection<T> remainingItems, Set<T> ok) {
        Iterator<T> it = remainingItems.iterator();
        while (it.hasNext()) {
            T item = it.next();
            if (!ok.contains(item)) continue;
            it.remove();
            return item;
        }
        throw new IllegalArgumentException("Internal Error");
    }

    public void getFirsts(Set<T> result) {
        this.getFirsts(result, null);
    }

    public void getFirsts(Set<T> result, Map<T, Collection<T>> reasons) {
        result.clear();
        result.addAll(this.orderedWorkingSet);
        for (Collection<T> sublist : this.source) {
            Iterator<T> iterator = sublist.iterator();
            iterator.next();
            while (iterator.hasNext()) {
                T nextItem = iterator.next();
                boolean changed = result.remove(nextItem);
                if (!changed || reasons == null) continue;
                reasons.put(nextItem, sublist);
            }
        }
    }
}

