/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.util.Pair;
import org.unicode.cldr.util.PathDescription;
import org.unicode.cldr.util.RegexLookup;

public class PathDescriptionParser {
    private static final String PROLOGUE = "PROLOGUE";
    private static final String VARIABLES = "VARIABLES";
    private static final String REFERENCES = "References";
    private final RegexLookup<Pair<String, String>> lookup = new RegexLookup(RegexLookup.LookupType.OPTIMIZED_DIRECTORY_PATTERN_LOOKUP);
    private String section = "";
    private String description = null;
    private final List<String> patterns = new ArrayList<String>();
    private final List<String> text = new ArrayList<String>();
    private final List<String> referenceLines = new ArrayList<String>();
    private final Pattern HEADER_PATTERN = Pattern.compile("^(#+)(?:[ ]+(.*))?$");
    private final Pattern VARIABLES_PATTERN = Pattern.compile("^# *VARIABLES *$");

    public RegexLookup<Pair<String, String>> parse(String fileName) {
        this.lookup.setPatternTransform(RegexLookup.RegexFinderTransformPathLDML);
        String string = PathDescription.getBigString(fileName);
        String[] lines = string.split("\n");
        int n = 0;
        try {
            for (String line : lines) {
                ++n;
                this.processLine(line.trim());
            }
            this.end();
        }
        catch (Throwable t2) {
            throw new RuntimeException("Failed parsing " + fileName + ":" + n + ": at " + this.section + "#" + this.description, t2);
        }
        return this.lookup;
    }

    private boolean inPrologue() {
        return this.section.equals(PROLOGUE);
    }

    private boolean inVariables() {
        return this.section.equals(VARIABLES);
    }

    private boolean inReferences() {
        return this.section.equals(REFERENCES);
    }

    private void processLine(String line) {
        if (line.startsWith("#")) {
            this.processHeader(line);
        } else {
            if (this.inPrologue() || this.beforePrologue()) {
                return;
            }
            if (this.inVariables()) {
                this.processVariable(line);
            } else if (this.inReferences()) {
                this.processReference(line);
            } else if (line.startsWith("- `")) {
                if (!line.endsWith("`")) {
                    throw new IllegalArgumentException("Bad regex line " + line);
                }
                this.processRegex(line.substring(3, line.length() - 1));
            } else {
                this.processBody(line);
            }
        }
    }

    private void processVariable(String line) {
        if (line.isBlank()) {
            return;
        }
        int pos = line.indexOf("=");
        if (pos < 0) {
            throw new IllegalArgumentException("Failed to read variable in " + line);
        }
        String varName = line.substring(0, pos).trim();
        String varValue = line.substring(pos + 1).trim();
        this.lookup.addVariable(varName, varValue);
    }

    private void processBody(String line) {
        this.text.add(line);
    }

    private void processRegex(String line) {
        this.patterns.add(line);
    }

    private void processReference(String line) {
        this.referenceLines.add(line);
    }

    public String getReferences() {
        return String.join((CharSequence)"\n", this.referenceLines).trim();
    }

    private void processHeader(String line) {
        this.endHeader();
        if (this.inReferences()) {
            throw new IllegalArgumentException("Disallowed: headers after start of # References");
        }
        Matcher m4 = this.HEADER_PATTERN.matcher(line);
        if (!m4.matches()) {
            throw new IllegalArgumentException("Malformed header " + line);
        }
        int headerLevel = m4.group(1).length();
        String title = m4.group(2);
        if (title == null) {
            title = "";
        }
        title = title.trim();
        if (headerLevel == 1) {
            if (this.VARIABLES_PATTERN.matcher(line).matches()) {
                if (this.beforePrologue()) {
                    throw new IllegalArgumentException("Prologue should precede # VARIABLES");
                }
                this.section = VARIABLES;
            } else {
                if (!this.beforePrologue()) {
                    throw new IllegalArgumentException("Extra # header after beginning of file");
                }
                this.section = PROLOGUE;
            }
            this.description = null;
        } else if (headerLevel == 2) {
            if (this.beforePrologue()) {
                throw new IllegalArgumentException("Expected header # line");
            }
            if (title.isBlank()) {
                throw new IllegalArgumentException("Sections ## may not be empty.");
            }
            this.section = title;
            this.description = null;
        } else if (headerLevel == 3) {
            this.description = title;
        } else {
            throw new IllegalArgumentException("Unexpected/unsupported header " + m4.group(1) + " (expected ## or ###) " + line);
        }
    }

    private void end() {
        if (!this.inReferences()) {
            throw new IllegalArgumentException("End of lines when not in # References");
        }
        if (this.getReferences().isEmpty()) {
            throw new IllegalArgumentException("No references were found in section: References");
        }
    }

    private void endHeader() {
        if (this.inPrologue() || this.beforePrologue()) {
            return;
        }
        this.processContent();
        this.resetContent();
    }

    private boolean beforePrologue() {
        return this.section.isEmpty();
    }

    private void processContent() {
        String textStr = String.join((CharSequence)"\n", this.text).trim();
        if (this.description == null) {
            if (!this.patterns.isEmpty() || !textStr.isBlank()) {
                throw new IllegalArgumentException("Didn't expect content above this line.");
            }
            return;
        }
        if (this.patterns.isEmpty() && !textStr.isBlank()) {
            throw new IllegalArgumentException("Content, but no regex patterns.");
        }
        if (!this.patterns.isEmpty() && textStr.isBlank()) {
            throw new IllegalArgumentException("Regex patterns, but no content");
        }
        if (this.patterns.isEmpty() && textStr.isBlank()) {
            throw new IllegalArgumentException("No content nor regex patterns");
        }
        if (this.patterns.size() > 1) {
            throw new IllegalArgumentException("Only one pattern is supported at present.");
        }
        this.lookup.add(this.patterns.get(0), Pair.of(this.description, textStr));
    }

    private void resetContent() {
        this.patterns.clear();
        this.text.clear();
    }
}

