/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.base.Splitter;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.text.Transform;
import com.ibm.icu.util.Output;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.RegexFileParser;
import org.unicode.cldr.util.RegexUtilities;

public class RegexLookup<T>
implements Iterable<Map.Entry<Finder, T>> {
    protected static final String SEPARATOR = "; ";
    private CldrUtility.VariableReplacer variables = new CldrUtility.VariableReplacer();
    private StorageInterfaceBase<T> storage;
    private Map<Finder, T> MEntries;
    private Transform<String, ? extends Finder> patternTransform = RegexFinderTransform;
    private Transform<String, ? extends T> valueTransform;
    private Merger<T> valueMerger;
    private final boolean allowNull = false;
    private LookupType _lookupType;
    public static Transform<String, RegexFinder> RegexFinderTransform = new Transform<String, RegexFinder>(){

        @Override
        public RegexFinder transform(String source) {
            return new RegexFinder(source);
        }
    };
    public static Transform<String, RegexFinder> RegexFinderTransformPath = new Transform<String, RegexFinder>(){

        @Override
        public RegexFinder transform(String source) {
            String newSource = source.replace("[@", "\\[@");
            return new RegexFinder((String)(newSource.startsWith("//") ? "^" + newSource : newSource));
        }
    };
    public static Transform<String, RegexFinder> RegexFinderTransformPath2 = new Transform<String, RegexFinder>(){

        @Override
        public RegexFinder transform(String source) {
            String newSource = source.replace("[@", "\\[@").replace('\'', '\"');
            return new RegexFinder((String)(newSource.startsWith("//") ? "^" + newSource : newSource));
        }
    };
    public static Transform<String, RegexFinder> RegexFinderTransformPathLDML = new Transform<String, RegexFinder>(){

        @Override
        public RegexFinder transform(String source) {
            if (source.startsWith("^") || source.startsWith("/")) {
                throw new IllegalArgumentException("Pattern must not start with ^ or /: ^//ldml/ is automatically inserted: " + source);
            }
            String newSource = "^//ldml/" + source.replace("[@", "\\[@");
            return new RegexFinder(newSource);
        }
    };

    public RegexLookup(LookupType type) {
        this._lookupType = type;
        switch (type) {
            case STAR_PATTERN_LOOKUP: {
                this.storage = new StarPatternMap();
                break;
            }
            case OPTIMIZED_DIRECTORY_PATTERN_LOOKUP: {
                this.storage = new RegexTree();
                break;
            }
            default: {
                this.MEntries = new LinkedHashMap<Finder, T>();
            }
        }
    }

    public RegexLookup() {
        this(LookupType.OPTIMIZED_DIRECTORY_PATTERN_LOOKUP);
    }

    public final T get(String source) {
        return this.get(source, null, null, null, null);
    }

    public T get(String source, Object context, Output<String[]> arguments) {
        return this.get(source, context, arguments, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(String source, Object context, Output<String[]> arguments, Output<Finder> matcherFound, Collection<String> failures) {
        if (this._lookupType == LookupType.STAR_PATTERN_LOOKUP) {
            T ret = this.storage.get(source, context, arguments, matcherFound);
            if (ret != null) {
                return ret;
            }
            if (failures != null) {
                for (Map.Entry<Finder, T> entry : this.storage.entrySet()) {
                    Finder matcher;
                    Finder finder = matcher = entry.getKey();
                    synchronized (finder) {
                        int failPoint = matcher.getFailPoint(source);
                        String show = source.substring(0, failPoint) + "\u2639" + source.substring(failPoint) + "\t" + matcher.toString();
                        failures.add(show);
                    }
                }
            }
        } else if (this._lookupType == LookupType.OPTIMIZED_DIRECTORY_PATTERN_LOOKUP) {
            T ret = this.storage.get(source, context, arguments, matcherFound);
            if (ret != null) {
                return ret;
            }
            if (failures != null) {
                for (Map.Entry<Finder, T> entry : this.storage.entrySet()) {
                    Finder matcher;
                    Finder finder = matcher = entry.getKey();
                    synchronized (finder) {
                        int failPoint = matcher.getFailPoint(source);
                        String show = source.substring(0, failPoint) + "\u2639" + source.substring(failPoint) + "\t" + matcher.toString();
                        failures.add(show);
                    }
                }
            }
        } else {
            for (Map.Entry<Finder, T> entry : this.MEntries.entrySet()) {
                Finder matcher;
                Finder finder = matcher = entry.getKey();
                synchronized (finder) {
                    Finder.Info firstInfo = new Finder.Info();
                    if (matcher.find(source, context, firstInfo)) {
                        if (arguments != null) {
                            arguments.value = firstInfo.value;
                        }
                        if (matcherFound != null) {
                            matcherFound.value = matcher;
                        }
                        return entry.getValue();
                    }
                    if (failures != null) {
                        int failPoint = matcher.getFailPoint(source);
                        String show = source.substring(0, failPoint) + "\u2639" + source.substring(failPoint) + "\t" + matcher.toString();
                        failures.add(show);
                    }
                }
            }
        }
        if (arguments != null) {
            arguments.value = null;
        }
        if (matcherFound != null) {
            matcherFound.value = null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> getAll(String source, Object context, List<Finder> matcherList, List<String> failures) {
        if (this._lookupType == LookupType.STAR_PATTERN_LOOKUP) {
            Output<String[]> firstInfo = new Output<String[]>();
            List<T> matches = this.storage.getAll(source, context, matcherList, firstInfo);
            if (matches != null) {
                return matches;
            }
            if (failures != null) {
                for (Map.Entry<Finder, T> entry : this.storage.entrySet()) {
                    Finder matcher;
                    Finder finder = matcher = entry.getKey();
                    synchronized (finder) {
                        int failPoint = matcher.getFailPoint(source);
                        String show = source.substring(0, failPoint) + "\u2639" + source.substring(failPoint) + "\t" + matcher.toString();
                        failures.add(show);
                    }
                }
            }
            return null;
        }
        if (this._lookupType == LookupType.OPTIMIZED_DIRECTORY_PATTERN_LOOKUP) {
            Output<String[]> info = new Output<String[]>();
            List<T> matches = this.storage.getAll(source, context, matcherList, info);
            if (matches != null) {
                return matches;
            }
            if (failures != null) {
                for (Map.Entry<Finder, T> entry : this.storage.entrySet()) {
                    Finder matcher;
                    Finder finder = matcher = entry.getKey();
                    synchronized (finder) {
                        int failPoint = matcher.getFailPoint(source);
                        String show = source.substring(0, failPoint) + "\u2639" + source.substring(failPoint) + "\t" + matcher.toString();
                        failures.add(show);
                    }
                }
            }
            return null;
        }
        ArrayList<T> matches = new ArrayList<T>();
        for (Map.Entry<Finder, T> entry : this.MEntries.entrySet()) {
            Finder.Info firstInfo;
            Finder matcher = entry.getKey();
            if (matcher.find(source, context, firstInfo = new Finder.Info())) {
                if (matcherList != null) {
                    matcherList.add(matcher);
                }
                matches.add(entry.getValue());
                continue;
            }
            if (failures == null) continue;
            int failPoint = matcher.getFailPoint(source);
            String show = source.substring(0, failPoint) + "\u2639" + source.substring(failPoint) + "\t" + matcher.toString();
            failures.add(show);
        }
        return matches;
    }

    public Map<String, T> getUnmatchedPatterns(Set<String> matched, Map<String, T> outputUnmatched) {
        Set<Map.Entry<Finder, T>> entrySet;
        outputUnmatched.clear();
        switch (this._lookupType) {
            case STAR_PATTERN_LOOKUP: {
                entrySet = this.storage.entrySet();
                break;
            }
            case OPTIMIZED_DIRECTORY_PATTERN_LOOKUP: {
                entrySet = this.storage.entrySet();
                break;
            }
            default: {
                entrySet = this.MEntries.entrySet();
            }
        }
        for (Map.Entry<Finder, T> entry : entrySet) {
            String pattern = entry.getKey().toString();
            if (matched.contains(pattern)) continue;
            outputUnmatched.put(pattern, entry.getValue());
        }
        return outputUnmatched;
    }

    public static <T, U> RegexLookup<T> of(Transform<String, Finder> patternTransform, Transform<String, T> valueTransform, Merger<T> valueMerger) {
        return new RegexLookup<T>().setPatternTransform(patternTransform).setValueTransform(valueTransform).setValueMerger(valueMerger);
    }

    public static <T> RegexLookup<T> of(Transform<String, T> valueTransform) {
        return new RegexLookup<T>().setValueTransform(valueTransform).setPatternTransform(RegexFinderTransform);
    }

    public static <T> RegexLookup<T> of() {
        return new RegexLookup<T>().setPatternTransform(RegexFinderTransform);
    }

    @Deprecated
    public static <T> RegexLookup<T> of(LookupType lookupType) {
        return RegexLookup.of(lookupType, RegexFinderTransform);
    }

    public static <T> RegexLookup<T> of(LookupType lookupType, Transform<String, RegexFinder> transform) {
        return new RegexLookup<T>(lookupType).setPatternTransform(transform);
    }

    public RegexLookup<T> setValueTransform(Transform<String, ? extends T> valueTransform) {
        this.valueTransform = valueTransform;
        return this;
    }

    public RegexLookup<T> setPatternTransform(Transform<String, ? extends Finder> patternTransform) {
        this.patternTransform = patternTransform != null ? patternTransform : RegexFinderTransform;
        return this;
    }

    public RegexLookup<T> setValueMerger(Merger<T> valueMerger) {
        this.valueMerger = valueMerger;
        return this;
    }

    public RegexLookup<T> loadFromFile(Class<?> baseClass, String filename) {
        RegexFileParser parser = this.setupRegexFileParser();
        parser.parse(baseClass, filename);
        return this;
    }

    public RegexLookup<T> loadFromString(String source) {
        RegexFileParser parser = this.setupRegexFileParser();
        parser.parseStrings("string", Splitter.on('\n').split(source));
        return this;
    }

    private RegexFileParser setupRegexFileParser() {
        RegexFileParser parser = new RegexFileParser();
        parser.setLineParser(new RegexFileParser.RegexLineParser(){

            @Override
            public void parse(String line) {
                int pos = line.indexOf(RegexLookup.SEPARATOR);
                if (pos < 0) {
                    throw new IllegalArgumentException("Illegal line, doesn't contain semicolon: " + line);
                }
                String source = line.substring(0, pos).trim();
                String target = line.substring(pos + 2).trim();
                try {
                    String result = RegexLookup.this.valueTransform == null ? target : RegexLookup.this.valueTransform.transform(target);
                    RegexLookup.this.add(source, result);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Failed to add <" + source + "> => <" + target + ">", e);
                }
            }
        });
        parser.setVariableProcessor(new RegexFileParser.VariableProcessor(){

            @Override
            public void add(String variable, String variableName) {
                RegexLookup.this.addVariable(variable, variableName);
            }

            @Override
            public String replace(String str) {
                return RegexLookup.this.variables.replace(str);
            }
        });
        return parser;
    }

    public RegexLookup<T> addVariable(String variable, String variableValue) {
        if (!variable.startsWith("%")) {
            throw new IllegalArgumentException("Variables must start with %");
        }
        this.variables.add(variable.trim(), variableValue.trim());
        return this;
    }

    public RegexLookup<T> add(String stringPattern, T target) {
        if (stringPattern.contains("%")) {
            stringPattern = this.variables.replace(stringPattern);
        }
        return this.addWithoutVariables(stringPattern, target);
    }

    public RegexLookup<T> addWithoutVariables(String stringPattern, T target) {
        Finder pattern0 = this.patternTransform.transform(stringPattern);
        return this.add(pattern0, target);
    }

    public RegexLookup<T> add(Finder pattern, T target) {
        T old;
        if (target == null) {
            throw new NullPointerException("null disallowed, unless allowNull(true) is called.");
        }
        switch (this._lookupType) {
            case STAR_PATTERN_LOOKUP: 
            case OPTIMIZED_DIRECTORY_PATTERN_LOOKUP: {
                old = this.storage.get(pattern);
                break;
            }
            default: {
                old = this.MEntries.get(pattern);
            }
        }
        if (old == null) {
            switch (this._lookupType) {
                case STAR_PATTERN_LOOKUP: 
                case OPTIMIZED_DIRECTORY_PATTERN_LOOKUP: {
                    this.storage.put(pattern, target);
                    break;
                }
                default: {
                    this.MEntries.put(pattern, target);
                    break;
                }
            }
        } else if (this.valueMerger != null) {
            this.valueMerger.merge(target, old);
        } else {
            throw new IllegalArgumentException("Duplicate matcher without Merger defined " + String.valueOf(pattern) + "; old: " + String.valueOf(old) + "; new: " + String.valueOf(target));
        }
        return this;
    }

    @Override
    public Iterator<Map.Entry<Finder, T>> iterator() {
        switch (this._lookupType) {
            case STAR_PATTERN_LOOKUP: 
            case OPTIMIZED_DIRECTORY_PATTERN_LOOKUP: {
                return Collections.unmodifiableCollection(this.storage.entrySet()).iterator();
            }
        }
        return Collections.unmodifiableCollection(this.MEntries.entrySet()).iterator();
    }

    public static String replace(String lookup, String ... arguments) {
        StringBuilder result = new StringBuilder();
        int last = 0;
        while (true) {
            int pos;
            if ((pos = lookup.indexOf("$", last)) < 0) break;
            result.append(lookup.substring(last, pos));
            int arg = lookup.charAt(pos + 1) - 48;
            try {
                result.append(arguments[arg]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Replacing $" + arg + " in <" + lookup + ">, but too few arguments supplied.");
            }
            last = pos + 2;
        }
        result.append(lookup.substring(last, lookup.length()));
        return result.toString();
    }

    public int size() {
        switch (this._lookupType) {
            case STAR_PATTERN_LOOKUP: 
            case OPTIMIZED_DIRECTORY_PATTERN_LOOKUP: {
                return this.storage.size();
            }
        }
        return this.MEntries.size();
    }

    public String toString() {
        return this.storage.toString();
    }

    public static interface Merger<T> {
        public T merge(T var1, T var2);
    }

    private static class NodeBase<T> {
        Finder _finder;
        T _val;
        Finder.Info _info = new Finder.Info();

        public NodeBase(Finder finder, T value) {
            this._finder = finder;
            this._val = value;
        }
    }

    private static class StarPatternMap<T>
    implements StorageInterfaceBase<T> {
        private Map<String, List<SPNode>> _spmap = new HashMap<String, List<SPNode>>();
        private int _size = 0;

        @Override
        public int size() {
            return this._size;
        }

        @Override
        public void put(Finder pattern, T value) {
            String starPattern = this.starPatternTransform(pattern.toString().replaceAll("\\(\\[\\^\"\\]\\*\\)", "*"));
            List<SPNode> candidates = this._spmap.get(starPattern);
            if (candidates == null) {
                candidates = new ArrayList<SPNode>();
            }
            SPNode newNode = new SPNode(pattern, value);
            candidates.add(newNode);
            this._spmap.put(starPattern, candidates);
            ++this._size;
        }

        @Override
        public T get(Finder finder) {
            String starPattern = this.starPatternTransform(finder.toString());
            List<SPNode> candidates = this._spmap.get(starPattern);
            if (candidates == null) {
                return null;
            }
            for (SPNode cand : candidates) {
                if (!cand._finder.equals(finder)) continue;
                return (T)cand._val;
            }
            return null;
        }

        @Override
        public List<T> getAll(String pattern, Object context, List<Finder> matcherList, Output<String[]> firstInfo) {
            ArrayList<SPNode> list = new ArrayList<SPNode>();
            ArrayList<Object> retList = new ArrayList<Object>();
            String starPattern = this.starPatternTransform(pattern);
            List<SPNode> candidates = this._spmap.get(starPattern);
            if (candidates == null) {
                return retList;
            }
            for (SPNode cand : candidates) {
                Finder.Info info = new Finder.Info();
                if (!cand._finder.find(pattern, context, info)) continue;
                list.add(cand);
                if (firstInfo == null) continue;
                firstInfo.value = info.value;
            }
            for (SPNode n : list) {
                retList.add(n._val);
                if (matcherList == null) continue;
                matcherList.add(n._finder);
            }
            return retList;
        }

        @Override
        public T get(String pattern, Object context, Output<String[]> arguments, Output<Finder> matcherFound) {
            ArrayList<Finder> matcherList = new ArrayList<Finder>();
            Output<String[]> firstInfo = new Output<String[]>();
            List<T> matches = this.getAll(pattern, context, matcherList, firstInfo);
            if (arguments != null && firstInfo.value != null) {
                Object object = arguments.value = matcherList.isEmpty() ? null : (String[])firstInfo.value;
            }
            if (matcherFound != null) {
                matcherFound.value = matcherList.size() > 0 ? (Finder)matcherList.get(0) : null;
            }
            return matches.size() > 0 ? (T)matches.get(0) : null;
        }

        @Override
        public Set<Map.Entry<Finder, T>> entrySet() {
            LinkedHashMap<Finder, Object> ret = new LinkedHashMap<Finder, Object>();
            for (Map.Entry<String, List<SPNode>> entry : this._spmap.entrySet()) {
                List<SPNode> candidates = entry.getValue();
                for (SPNode node : candidates) {
                    ret.put(node._finder, node._val);
                }
            }
            return ret.entrySet();
        }

        private String starPatternTransform(String path) {
            Pattern ATTRIBUTE_PATTERN_OLD = PatternCache.get("=\"([^\"]*)\"");
            Matcher starAttributeMatcher = ATTRIBUTE_PATTERN_OLD.matcher(path);
            StringBuilder starredPathOld = new StringBuilder();
            int lastEnd = 0;
            while (starAttributeMatcher.find()) {
                int start = starAttributeMatcher.start(1);
                int end = starAttributeMatcher.end(1);
                starredPathOld.append(path, lastEnd, start);
                starredPathOld.append("*");
                lastEnd = end;
            }
            starredPathOld.append(path.substring(lastEnd));
            String result = Utility.unescape(starredPathOld.toString());
            if (result.startsWith("^") && result.endsWith("$")) {
                result = result.substring(1, result.length() - 1);
            }
            return result;
        }

        public class SPNode
        extends NodeBase<T> {
            public SPNode(Finder finder, T val) {
                super(finder, val);
            }

            public String toString() {
                return this._finder.toString();
            }
        }
    }

    private static class RegexTree<T>
    implements StorageInterfaceBase<T> {
        private RTNode root;
        private int _size = 0;
        private RTNodeRankComparator rankComparator = new RTNodeRankComparator();

        public RegexTree() {
            this.root = new RTNode("", null);
        }

        @Override
        public int size() {
            return this._size;
        }

        @Override
        public void put(Finder pattern, T value) {
            this.root.put(new RTNode(pattern, value, this._size));
            ++this._size;
        }

        @Override
        public T get(Finder finder) {
            return this.root.get(finder);
        }

        @Override
        public List<T> getAll(String pattern, Object context, List<Finder> matcherList, Output<String[]> firstInfo) {
            ArrayList<RTNode> list = new ArrayList<RTNode>();
            ArrayList<Object> retList = new ArrayList<Object>();
            this.root.addToList(pattern, context, list);
            Collections.sort(list, this.rankComparator);
            boolean isFirst = true;
            if (firstInfo != null && !list.isEmpty()) {
                RTNode firstNode = (RTNode)list.get(0);
                if (firstNode._info != null) {
                    firstInfo.value = firstNode._info.value;
                }
            }
            for (RTNode n : list) {
                if (!isFirst) continue;
                firstInfo.value = n._info.value;
                isFirst = false;
            }
            for (RTNode n : list) {
                retList.add(n._val);
                if (matcherList == null) continue;
                matcherList.add(n._finder);
            }
            return retList;
        }

        @Override
        public T get(String pattern, Object context, Output<String[]> arguments, Output<Finder> matcherFound) {
            ArrayList<Finder> matcherList = new ArrayList<Finder>();
            Output<String[]> firstInfo = new Output<String[]>();
            List<T> matches = this.getAll(pattern, context, matcherList, firstInfo);
            if (arguments != null) {
                arguments.value = firstInfo.value;
                arguments.value = firstInfo.value;
            }
            if (matcherFound != null) {
                matcherFound.value = matcherList.size() > 0 ? (Finder)matcherList.get(0) : null;
            }
            return matches.size() > 0 ? (T)matches.get(0) : null;
        }

        @Override
        public Set<Map.Entry<Finder, T>> entrySet() {
            LinkedHashMap<Finder, Object> ret = new LinkedHashMap<Finder, Object>();
            TreeSet<RTNode> s2 = new TreeSet<RTNode>(this.rankComparator);
            this.root.addToEntrySet(s2);
            for (RTNode n : s2) {
                ret.put(n._finder, n._val);
            }
            return ret.entrySet();
        }

        public String toString() {
            return this.root.toString();
        }

        class RTNodeRankComparator
        implements Comparator<RTNode> {
            RTNodeRankComparator() {
            }

            @Override
            public int compare(RTNode a, RTNode b) {
                if (a == b) {
                    return 0;
                }
                if (a == null) {
                    return -1;
                }
                if (b == null) {
                    return 1;
                }
                if (a._rank == b._rank) {
                    return 0;
                }
                if (a._rank > b._rank) {
                    return 1;
                }
                return -1;
            }
        }

        public class RTNode
        extends NodeBase<T> {
            List<RTNode> _children;
            int _rank;

            public RTNode(Finder finder, T val, int rank) {
                super(finder, val);
                this._children = new ArrayList<RTNode>();
                this._rank = -1;
                this._rank = rank;
            }

            public RTNode(String key, T val) {
                super(new RegexFinder(key), val);
                this._children = new ArrayList<RTNode>();
                this._rank = -1;
                this._info = new Finder.Info();
            }

            public void put(RTNode node) {
                if (this._children.size() == 0) {
                    this._children.add(node);
                } else {
                    String maxSimilarChars = "";
                    int insertIndex = 0;
                    for (int i = 0; i < this._children.size(); ++i) {
                        RTNode child = this._children.get(i);
                        String childFinderPattern = child._finder.toString();
                        if (childFinderPattern.length() > 0 && childFinderPattern.charAt(childFinderPattern.length() - 1) == '$') {
                            childFinderPattern = childFinderPattern.substring(0, childFinderPattern.length() - 1);
                        } else if (child._rank == -1) {
                            childFinderPattern = childFinderPattern.substring(0, childFinderPattern.length() - 2);
                        }
                        if (node._finder.equals(child._finder)) {
                            child._finder = node._finder;
                            child._val = node._val;
                            if (child._rank == -1) {
                                child._rank = node._rank;
                            } else {
                                --RegexTree.this._size;
                            }
                            return;
                        }
                        if (child._rank == -1 && node._finder.toString().startsWith(childFinderPattern)) {
                            child.put(node);
                            return;
                        }
                        String gcp = this.greatestCommonPrefix(childFinderPattern, node._finder.toString());
                        if ((gcp = this.removeExtraChars(gcp)).length() <= maxSimilarChars.length()) continue;
                        maxSimilarChars = gcp;
                        insertIndex = i;
                    }
                    String finderPattern = this._finder.toString();
                    if (finderPattern.length() > 0 && finderPattern.charAt(finderPattern.length() - 1) == '$') {
                        finderPattern = finderPattern.substring(0, finderPattern.length() - 1);
                    } else if (!finderPattern.equals("") && this._rank == -1) {
                        finderPattern = finderPattern.substring(0, finderPattern.length() - 2);
                    }
                    if (maxSimilarChars.equals(finderPattern)) {
                        this._children.add(node);
                    } else {
                        RTNode newParent = new RTNode(maxSimilarChars + ".*", null);
                        newParent._children.add(this._children.get(insertIndex));
                        newParent._children.add(node);
                        this._children.remove(insertIndex);
                        this._children.add(insertIndex, newParent);
                    }
                }
            }

            private String removeExtraChars(String input) {
                String ret = input.substring(0, Math.max(0, input.lastIndexOf(47)));
                while (ret.lastIndexOf(40) != -1 && ret.lastIndexOf(40) > ret.lastIndexOf(41) || ret.lastIndexOf(91) != -1 && ret.lastIndexOf(91) > ret.lastIndexOf(93) || ret.lastIndexOf(123) != -1 && ret.lastIndexOf(123) > ret.lastIndexOf(125)) {
                    ret = ret.substring(0, Math.max(0, ret.lastIndexOf(47)));
                }
                return ret;
            }

            public T get(Finder finder) {
                Object ret = null;
                if (this._children.size() == 0) {
                    return null;
                }
                for (RTNode child : this._children) {
                    if (child._rank != -1 && finder.equals(child._finder)) {
                        return child._val;
                    }
                    String childFinderPattern = child._finder.toString();
                    if (childFinderPattern.length() > 0 && childFinderPattern.charAt(childFinderPattern.length() - 1) == '$') {
                        childFinderPattern = childFinderPattern.substring(0, childFinderPattern.length() - 1);
                    } else if (child._rank == -1) {
                        childFinderPattern = childFinderPattern.substring(0, childFinderPattern.length() - 2);
                    }
                    if (!finder.toString().startsWith(childFinderPattern) || (ret = (Object)child.get(finder)) == null) continue;
                    break;
                }
                return ret;
            }

            public void addToEntrySet(TreeSet<RTNode> s2) {
                if (this._children.size() == 0) {
                    return;
                }
                for (RTNode child : this._children) {
                    if (child._rank != -1) {
                        s2.add(child);
                    }
                    child.addToEntrySet(s2);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void addToList(String pattern, Object context, List<RTNode> list) {
                if (this._children.size() == 0) {
                    return;
                }
                Finder.Info firstInfo = new Finder.Info();
                for (RTNode child : this._children) {
                    boolean found;
                    Finder finder = child._finder;
                    synchronized (finder) {
                        found = child._finder.find(pattern, context, firstInfo);
                    }
                    if (!found) continue;
                    if (child._rank != -1) {
                        list.add(child);
                    }
                    if (child._info != null) {
                        child._info.value = firstInfo.value;
                    } else {
                        child._info = new Finder.Info();
                        child._info.value = firstInfo.value;
                    }
                    child.addToList(pattern, context, list);
                }
            }

            public String toString() {
                return this.toString("", new StringBuilder()).toString();
            }

            private StringBuilder toString(String prefix, StringBuilder result) {
                result.append(prefix).append(this._finder.toString()).append("\n");
                for (RTNode child : this._children) {
                    child.toString(prefix + "\t", result);
                }
                return result;
            }

            public String greatestCommonPrefix(String a, String b) {
                int minLength = Math.min(a.length(), b.length());
                for (int i = 0; i < minLength; ++i) {
                    if (a.charAt(i) == b.charAt(i)) continue;
                    return a.substring(0, i);
                }
                return a.substring(0, minLength);
            }
        }
    }

    private static interface StorageInterfaceBase<T> {
        public Set<Map.Entry<Finder, T>> entrySet();

        public T get(Finder var1);

        public T get(String var1, Object var2, Output<String[]> var3, Output<Finder> var4);

        public List<T> getAll(String var1, Object var2, List<Finder> var3, Output<String[]> var4);

        public void put(Finder var1, T var2);

        public int size();
    }

    public static class RegexFinder
    extends Finder {
        private final Matcher matcher;
        protected final Pattern pattern;

        public RegexFinder(String pattern) {
            this.pattern = Pattern.compile(pattern, 4);
            this.matcher = this.pattern.matcher("");
        }

        @Override
        public boolean matches(String item, Object context, Finder.Info info) {
            Matcher matcher = this.matcher;
            synchronized (matcher) {
                try {
                    boolean result = this.matcher.reset(item).matches();
                    this.extractInfo(info, result);
                    return result;
                }
                catch (StringIndexOutOfBoundsException e) {
                    throw new IllegalArgumentException("Matching error caused by pattern: [" + this.matcher.toString() + "] on text: [" + item + "]", e);
                }
            }
        }

        private void extractInfo(Finder.Info info, boolean result) {
            if (result && info != null) {
                int limit = this.matcher.groupCount() + 1;
                String[] value = new String[limit];
                for (int i = 0; i < limit; ++i) {
                    value[i] = this.matcher.group(i);
                }
                info.value = value;
            }
        }

        @Override
        public boolean find(String item, Object context, Finder.Info info) {
            Matcher matcher = this.matcher;
            synchronized (matcher) {
                try {
                    boolean result = this.matcher.reset(item).find();
                    this.extractInfo(info, result);
                    return result;
                }
                catch (StringIndexOutOfBoundsException e) {
                    throw new IllegalArgumentException("Matching error caused by pattern: [" + this.matcher.toString() + "] on text: [" + item + "]", e);
                }
            }
        }

        public String toString() {
            return this.pattern.pattern();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            return this.toString().equals(obj.toString());
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getFailPoint(String source) {
            Matcher matcher = this.matcher;
            synchronized (matcher) {
                return RegexUtilities.findMismatch(this.matcher, (CharSequence)source);
            }
        }
    }

    public static abstract class Finder {
        public abstract boolean find(String var1, Object var2, Info var3);

        public abstract boolean matches(String var1, Object var2, Info var3);

        public int getFailPoint(String source) {
            return -1;
        }

        public static class Info {
            public String[] value;
        }
    }

    public static enum LookupType {
        STAR_PATTERN_LOOKUP,
        OPTIMIZED_DIRECTORY_PATTERN_LOOKUP,
        STANDARD;

    }
}

