/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.ibm.icu.text.UnicodeSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.FileReaders;
import org.unicode.cldr.util.TempPrintWriter;
import org.unicode.cldr.util.With;

public class ScriptToExemplars {
    public static final String FILE_PATH = "data/locales/scriptToExemplars.txt";

    public static UnicodeSet getExemplars(String script) {
        return ScriptToExemplarsLoader.SINGLETON.getExemplars(script);
    }

    private static String getCommentBlock() {
        return String.join((CharSequence)"\n", ScriptToExemplarsLoader.SINGLETON.comments) + "\n";
    }

    public static void write(Map<String, UnicodeSet> expected) {
        File file = new File(CLDRPaths.UTIL_SRC_DATA_DIR, FILE_PATH);
        try (TempPrintWriter out = new TempPrintWriter(file);){
            out.println(ScriptToExemplars.getCommentBlock());
            for (Map.Entry<String, UnicodeSet> entry : expected.entrySet()) {
                String script = entry.getKey();
                UnicodeSet flattened = entry.getValue();
                if (flattened.isEmpty()) continue;
                out.println(script + " ;\t" + flattened.size() + " ;\t" + flattened.toPattern(false));
            }
            System.err.println("Wrote: " + file.getAbsolutePath() + "\n Please check it carefully and commit it if needed.");
        }
    }

    private static class ScriptToExemplarsLoader {
        private static final ScriptToExemplarsLoader SINGLETON = new ScriptToExemplarsLoader();
        private Map<String, UnicodeSet> data;
        private String[] comments;

        private ScriptToExemplarsLoader() {
            TreeMap<String, UnicodeSet> _data = Maps.newTreeMap();
            ArrayList<String> _comments = new ArrayList<String>();
            try (BufferedReader reader = FileReaders.openFile(ScriptToExemplars.class, ScriptToExemplars.FILE_PATH);){
                Iterable<String> rlsi = With.toIterable(new FileReaders.ReadLineSimpleIterator(reader));
                for (String line : rlsi) {
                    if (line.isBlank()) continue;
                    if (line.startsWith("#")) {
                        _comments.add(line.trim());
                        continue;
                    }
                    Iterator<String> parts = Splitter.on(';').trimResults().split(line).iterator();
                    String script = parts.next();
                    int size = Integer.parseInt(parts.next());
                    UnicodeSet uset = new UnicodeSet(parts.next()).freeze();
                    _data.put(script, uset);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.data = ImmutableMap.copyOf(_data);
            this.comments = _comments.toArray(new String[_comments.size()]);
        }

        private UnicodeSet getExemplars(String script) {
            UnicodeSet result = this.data.get(script);
            return result == null ? UnicodeSet.EMPTY : result;
        }
    }
}

