/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.unicode.cldr.util.XPathParser;
import org.unicode.cldr.util.XPathValue;

public class SimpleXPathParts
extends XPathParser {
    final List<Element> elements = new LinkedList<Element>();
    private final String xpath;

    @Override
    public String getElement(int i) {
        if (i < 0) {
            i = this.elements.size() + i;
        }
        return this.elements.get((int)i).name;
    }

    public int findElement(String elementName) {
        for (int i = 0; i < this.elements.size(); ++i) {
            Element e = this.elements.get(i);
            if (!e.name.equals(elementName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean containsElement(String elementName) {
        return this.findElement(elementName) >= 0;
    }

    @Override
    public String getAttributeValue(int i, String attribute) {
        if (i < 0) {
            i = this.elements.size() + i;
        }
        return this.elements.get((int)i).attributes.get(attribute);
    }

    @Override
    public Map<String, String> getAttributes(int elementIndex) {
        return this.elements.get(elementIndex >= 0 ? elementIndex : elementIndex + this.size()).getAttributes();
    }

    @Override
    public boolean containsAttribute(String attribute) {
        for (Element e : this.elements) {
            if (!e.containsAttribute(attribute)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void handleClearElements() {
        this.elements.clear();
    }

    @Override
    protected void handleAddElement(String element) {
        this.elements.add(new Element(element));
    }

    @Override
    protected void handleAddAttribute(String attribute, String value) {
        this.elements.get((int)(this.elements.size() - 1)).attributes.put(attribute, value);
    }

    SimpleXPathParts(String xpath) {
        this.xpath = xpath;
        this.handleParse(xpath, true);
    }

    @Override
    public String toString() {
        return this.xpath;
    }

    static XPathValue getFrozenInstance(String xpath) {
        return new SimpleXPathParts(xpath);
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    private final class Element {
        public final String name;
        public final Map<String, String> attributes = new TreeMap<String, String>();

        public Element(String name) {
            this.name = name;
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public boolean containsAttribute(String attribute) {
            return this.attributes.containsKey(attribute);
        }
    }
}

