/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.text.Transform;
import java.util.Arrays;
import java.util.Iterator;
import org.unicode.cldr.util.With;

public final class Transformer<S, V>
implements Iterator<V> {
    private final Iterator<? extends S> iterator;
    private final Transform<S, ? extends V> transform;
    private V nextItem;

    public static <S, V> Transformer<S, V> iterator(Transform<S, ? extends V> transform, Iterator<? extends S> iterator) {
        return new Transformer<S, V>(transform, iterator);
    }

    public static <S, V> Transformer<S, V> iterator(Transform<S, ? extends V> transform, Iterable<? extends S> iterable) {
        return new Transformer<S, V>(transform, iterable.iterator());
    }

    public static <S, V> Transformer<S, V> iterator(Transform<S, ? extends V> transform, S ... items) {
        return new Transformer<S, V>(transform, Arrays.asList(items).iterator());
    }

    public static <S, V> With<V> iterable(Transform<S, ? extends V> transform, Iterator<? extends S> iterator) {
        return With.in(new Iterator[]{new Transformer<S, V>(transform, iterator)});
    }

    public static <S, V> With<V> iterable(Transform<S, ? extends V> transform, Iterable<? extends S> iterable) {
        return With.in(new Iterator[]{new Transformer<S, V>(transform, iterable.iterator())});
    }

    public static <S, V> With<V> iterable(Transform<S, ? extends V> transform, S ... items) {
        return With.in(new Iterator[]{new Transformer<S, V>(transform, Arrays.asList(items).iterator())});
    }

    private Transformer(Transform<S, ? extends V> transform, Iterator<? extends S> iterator) {
        this.transform = transform;
        this.iterator = iterator;
        this.fillInNext();
    }

    @Override
    public boolean hasNext() {
        return this.nextItem != null;
    }

    @Override
    public V next() {
        if (this.nextItem == null) {
            throw new IllegalArgumentException();
        }
        return this.fillInNext();
    }

    private V fillInNext() {
        V result = this.nextItem;
        while (this.iterator.hasNext()) {
            this.nextItem = this.transform.transform(this.iterator.next());
            if (this.nextItem == null) continue;
            return result;
        }
        this.nextItem = null;
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

