/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.ibm.icu.util.Output;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.Pair;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.With;

public class UnitParser
implements With.SimpleIterator<String> {
    public static final Splitter DASH_SPLITTER = Splitter.on('-');
    public static final Joiner DASH_JOIN = Joiner.on('-');
    private String bufferedItem = null;
    private SupplementalDataInfo.UnitIdComponentType bufferedType = null;
    private Iterator<String> source;
    private SupplementalDataInfo.UnitIdComponentType type;
    Function<String, SupplementalDataInfo.UnitIdComponentType> componentTypeSupplier;
    private String original;

    public UnitParser(Function<String, SupplementalDataInfo.UnitIdComponentType> componentTypeSupplier) {
        this.componentTypeSupplier = componentTypeSupplier;
    }

    public UnitParser() {
        this(CLDRConfig.getInstance().getSupplementalDataInfo()::getUnitIdComponentType);
    }

    public UnitParser set(String source) {
        if (source == null) {
            throw new IllegalArgumentException("Unit Parser doesn't handle null");
        }
        this.bufferedItem = null;
        this.original = source;
        this.source = DASH_SPLITTER.split(source).iterator();
        return this;
    }

    public List<Pair<SupplementalDataInfo.UnitIdComponentType, String>> getRemaining() {
        ArrayList<Pair<SupplementalDataInfo.UnitIdComponentType, String>> result = new ArrayList<Pair<SupplementalDataInfo.UnitIdComponentType, String>>();
        Output<SupplementalDataInfo.UnitIdComponentType> type = new Output<SupplementalDataInfo.UnitIdComponentType>();
        String item;
        while ((item = this.nextParse(type)) != null) {
            result.add(Pair.of((SupplementalDataInfo.UnitIdComponentType)((Object)type.value), item));
        }
        return result;
    }

    public String nextParse(Output<SupplementalDataInfo.UnitIdComponentType> unitIdComponentType) {
        String result = this.next();
        unitIdComponentType.value = this.type;
        return result;
    }

    public SupplementalDataInfo.UnitIdComponentType getLastUnitIdComponentType() {
        return this.type;
    }

    @Override
    public String next() {
        String output = null;
        State state = State.start;
        SupplementalDataInfo.UnitIdComponentType outputType = null;
        while (true) {
            if (this.bufferedItem == null) {
                if (!this.source.hasNext()) break;
                this.bufferedItem = this.source.next();
                this.bufferedType = this.componentTypeSupplier.apply(this.bufferedItem);
            }
            block0 : switch (this.bufferedType) {
                case prefix: {
                    switch (state) {
                        case start: {
                            state = State.havePrefix;
                            break block0;
                        }
                        case havePrefix: {
                            break block0;
                        }
                        case haveBaseOrSuffix: {
                            this.type = outputType == SupplementalDataInfo.UnitIdComponentType.suffix ? SupplementalDataInfo.UnitIdComponentType.base : outputType;
                            return output;
                        }
                    }
                    break;
                }
                case base: {
                    switch (state) {
                        case start: 
                        case havePrefix: {
                            state = State.haveBaseOrSuffix;
                            break block0;
                        }
                        case haveBaseOrSuffix: {
                            this.type = outputType == SupplementalDataInfo.UnitIdComponentType.suffix ? SupplementalDataInfo.UnitIdComponentType.base : outputType;
                            return output;
                        }
                    }
                    break;
                }
                case suffix: {
                    switch (state) {
                        case start: 
                        case havePrefix: {
                            throw new IllegalArgumentException("Unit suffix must follow base: " + this.original + " \u2192 " + output + " \u274c " + this.bufferedItem);
                        }
                    }
                    break;
                }
                case and: 
                case per: 
                case power: {
                    switch (state) {
                        case start: {
                            output = this.bufferedItem;
                            this.bufferedItem = null;
                            this.type = this.bufferedType;
                            return output;
                        }
                        case havePrefix: {
                            throw new IllegalArgumentException("Unit prefix must be followed with base: " + this.original + " \u2192 " + output + " \u274c " + this.bufferedItem);
                        }
                        case haveBaseOrSuffix: {
                            this.type = outputType == SupplementalDataInfo.UnitIdComponentType.suffix ? SupplementalDataInfo.UnitIdComponentType.base : outputType;
                            return output;
                        }
                    }
                }
            }
            output = output == null ? this.bufferedItem : output + "-" + this.bufferedItem;
            this.bufferedItem = null;
            outputType = this.bufferedType;
        }
        switch (state) {
            default: {
                return null;
            }
            case havePrefix: {
                throw new IllegalArgumentException("Unit prefix must be followed with base: " + this.original + " \u2192 " + output + " \u274c " + this.bufferedItem);
            }
            case haveBaseOrSuffix: 
        }
        this.type = outputType == SupplementalDataInfo.UnitIdComponentType.suffix ? SupplementalDataInfo.UnitIdComponentType.base : outputType;
        return output;
    }

    public SupplementalDataInfo.UnitIdComponentType getUnitIdComponentType(String part) {
        return this.componentTypeSupplier.apply(part);
    }

    private static enum State {
        start,
        havePrefix,
        haveBaseOrSuffix;

    }
}

