/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.util.ICUUncheckedIOException;
import java.io.IOException;
import org.unicode.cldr.util.StringByteConverter;

public class Utf8StringByteConverter
extends StringByteConverter {
    char lead = '\u0000';

    @Override
    public int toBytes(char ch, byte[] output, int bytePosition) {
        if (this.lead != '\u0000') {
            if (UTF16.isTrailSurrogate(ch)) {
                int cp = UCharacter.getCodePoint(this.lead, ch);
                output[bytePosition++] = (byte)(0xF0 | cp >>> 18);
                output[bytePosition++] = (byte)(0x80 | cp >>> 12 & 0x3F);
                output[bytePosition++] = (byte)(0x80 | cp >>> 6 & 0x3F);
                output[bytePosition++] = (byte)(0x80 | cp & 0x3F);
                this.lead = '\u0000';
                return bytePosition;
            }
            output[bytePosition++] = (byte)(0xE0 | this.lead >>> 12);
            output[bytePosition++] = (byte)(0x80 | this.lead >>> 6 & 0x3F);
            output[bytePosition++] = (byte)(0x80 | this.lead & 0x3F);
            this.lead = '\u0000';
        }
        if (ch < '\u0080') {
            output[bytePosition++] = (byte)ch;
        } else if (ch < '\u0800') {
            output[bytePosition++] = (byte)(0xC0 | ch >>> 6);
            output[bytePosition++] = (byte)(0x80 | ch & 0x3F);
        } else if (ch >= '\ud800' && ch < '\udc00') {
            this.lead = ch;
        } else {
            output[bytePosition++] = (byte)(0xE0 | ch >>> 12);
            output[bytePosition++] = (byte)(0x80 | ch >>> 6 & 0x3F);
            output[bytePosition++] = (byte)(0x80 | ch & 0x3F);
        }
        return bytePosition;
    }

    @Override
    public int toBytes(byte[] output, int bytePosition) {
        if (this.lead != '\u0000') {
            output[bytePosition++] = (byte)(0xE0 | this.lead >>> 12);
            output[bytePosition++] = (byte)(0x80 | this.lead >>> 6 & 0x3F);
            output[bytePosition++] = (byte)(0x80 | this.lead & 0x3F);
            this.lead = '\u0000';
        }
        return bytePosition;
    }

    @Override
    public int getMaxBytesPerChar() {
        return 4;
    }

    @Override
    public Appendable fromBytes(byte[] input, int byteStart, int byteLength, Appendable result) {
        try {
            while (byteStart < byteLength) {
                char b;
                if ((b = (char)(input[byteStart++] & 0xFF)) >= '\u0080') {
                    if (b < '\u00e0') {
                        b = (char)(b & 0x1F);
                        b = (char)(b << 6);
                        b = (char)(b | (char)(input[byteStart++] & 0x3F));
                    } else if (b < '\u00f0') {
                        b = (char)(b & 0xF);
                        b = (char)(b << 6);
                        b = (char)(b | (char)(input[byteStart++] & 0x3F));
                        b = (char)(b << 6);
                        b = (char)(b | (char)(input[byteStart++] & 0x3F));
                    } else {
                        int cp = (b & 7) << 6;
                        cp |= (char)(input[byteStart++] & 0x3F);
                        cp <<= 6;
                        cp |= (char)(input[byteStart++] & 0x3F);
                        cp <<= 6;
                        result.append(UTF16.getLeadSurrogate(cp |= (char)(input[byteStart++] & 0x3F)));
                        b = UTF16.getTrailSurrogate(cp);
                    }
                }
                result.append(b);
            }
            return result;
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException("Internal error", e);
        }
    }
}

