/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.collect.Iterators;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.util.Freezable;
import com.ibm.icu.util.Output;
import com.ibm.icu.util.VersionInfo;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.CodeFallback;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.LocaleInheritanceInfo;
import org.unicode.cldr.util.Log;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.SimpleXMLSource;
import org.unicode.cldr.util.XMLNormalizingLoader;
import org.unicode.cldr.util.XPathParts;
import org.xml.sax.Locator;

public abstract class XMLSource
implements Freezable<XMLSource>,
Iterable<String> {
    public static final String CODE_FALLBACK_ID = "code-fallback";
    public static final String ROOT_ID = "root";
    private static final String TRACE_INDENT = " ";
    private String localeID;
    private boolean nonInheriting;
    private TreeMap<String, String> aliasCache;
    private LinkedHashMap<String, List<String>> reverseAliasCache;
    protected boolean locked;
    transient String[] fixedPath = new String[1];
    protected boolean cachingIsEnabled = true;
    private final List<WeakReference<Listener>> listeners = new ArrayList<WeakReference<Listener>>();
    private DtdType XMLNormalizingDtdType;
    private static final boolean LOG_PROGRESS = false;

    public void disableCaching() {
        this.cachingIsEnabled = false;
    }

    public String getLocaleID() {
        return this.localeID;
    }

    public void setLocaleID(String localeID) {
        if (this.locked) {
            throw new UnsupportedOperationException("Attempt to modify locked object");
        }
        this.localeID = localeID;
    }

    public void putAll(Map<String, String> tempMap, int conflict_resolution) {
        for (String path : tempMap.keySet()) {
            if (conflict_resolution == 0 && this.getValueAtPath(path) != null) continue;
            this.putValueAtPath(path, tempMap.get(path));
        }
    }

    public void putAll(XMLSource otherSource, int conflict_resolution) {
        for (String path : otherSource) {
            String newValue;
            String oldValue = this.getValueAtDPath(path);
            if (conflict_resolution == 0 && oldValue != null || (newValue = otherSource.getValueAtDPath(path)).equals(oldValue)) continue;
            String fullPath = this.putValueAtPath(otherSource.getFullPathAtDPath(path), newValue);
            this.addSourceLocation(fullPath, otherSource.getSourceLocation(fullPath));
        }
    }

    public void removeAll(Collection<String> xpaths) {
        for (String xpath : xpaths) {
            this.removeValueAtDPath(xpath);
        }
    }

    @Override
    public boolean isFrozen() {
        return this.locked;
    }

    public String putValueAtPath(String xpath, String value) {
        xpath = xpath.intern();
        if (this.locked) {
            throw new UnsupportedOperationException("Attempt to modify locked object");
        }
        String distinguishingXPath = CLDRFile.getDistinguishingXPath(xpath, this.fixedPath);
        this.putValueAtDPath(distinguishingXPath, value);
        if (!this.fixedPath[0].equals(distinguishingXPath)) {
            this.clearCache();
            this.putFullPathAtDPath(distinguishingXPath, this.fixedPath[0]);
        }
        return distinguishingXPath;
    }

    protected synchronized TreeMap<String, String> getAliases() {
        if (!this.cachingIsEnabled) {
            return this.loadAliases();
        }
        if (this.aliasCache == null) {
            this.aliasCache = this.loadAliases();
        }
        return this.aliasCache;
    }

    private TreeMap<String, String> loadAliases() {
        TreeMap<String, String> aliasMap = new TreeMap<String, String>();
        for (String path : this) {
            String fullPath;
            Alias temp;
            if (!Alias.isAliasPath(path) || (temp = Alias.make(fullPath = this.getFullPathAtDPath(path = path.intern()).intern())) == null) continue;
            aliasMap.put(temp.getOldPath(), temp.getNewPath());
        }
        return aliasMap;
    }

    private LinkedHashMap<String, List<String>> getReverseAliases() {
        if (this.cachingIsEnabled && this.reverseAliasCache != null) {
            return this.reverseAliasCache;
        }
        TreeMap<String, String> aliases = this.getAliases();
        HashMap<String, List> reverse = new HashMap<String, List>();
        for (Map.Entry entry : aliases.entrySet()) {
            List list = reverse.computeIfAbsent((String)entry.getValue(), k -> new ArrayList());
            list.add((String)entry.getKey());
        }
        LinkedHashMap<String, List<String>> reverseAliasMap = new LinkedHashMap<String, List<String>>(new TreeMap(reverse));
        if (this.cachingIsEnabled) {
            this.reverseAliasCache = reverseAliasMap;
        }
        return reverseAliasMap;
    }

    private void clearCache() {
        this.aliasCache = null;
    }

    public String getSourceLocaleID(String path, CLDRFile.Status status) {
        if (status != null) {
            status.pathWhereFound = CLDRFile.getDistinguishingXPath(path, null);
        }
        return this.getLocaleID();
    }

    public String getSourceLocaleIdExtended(String path, CLDRFile.Status status, boolean skipInheritanceMarker, List<LocaleInheritanceInfo> list) {
        String locale = this.getSourceLocaleID(path, status);
        if (list != null) {
            if (this.hasValueAtDPath(path)) {
                list.add(new LocaleInheritanceInfo(locale, path, LocaleInheritanceInfo.Reason.value));
            } else {
                list.add(new LocaleInheritanceInfo(locale, path, LocaleInheritanceInfo.Reason.none));
            }
        }
        return locale;
    }

    public void removeValueAtPath(String xpath) {
        if (this.locked) {
            throw new UnsupportedOperationException("Attempt to modify locked object");
        }
        this.clearCache();
        this.removeValueAtDPath(CLDRFile.getDistinguishingXPath(xpath, null));
    }

    public String getValueAtPath(String xpath) {
        return this.getValueAtDPath(CLDRFile.getDistinguishingXPath(xpath, null));
    }

    public String getFullPath(String xpath) {
        return this.getFullPathAtDPath(CLDRFile.getDistinguishingXPath(xpath, null));
    }

    public abstract void putFullPathAtDPath(String var1, String var2);

    public abstract void putValueAtDPath(String var1, String var2);

    public abstract void removeValueAtDPath(String var1);

    public abstract String getValueAtDPath(String var1);

    public boolean hasValueAtDPath(String path) {
        return this.getValueAtDPath(path) != null;
    }

    public Date getChangeDateAtDPath(String path) {
        return null;
    }

    public abstract String getFullPathAtDPath(String var1);

    public abstract XPathParts.Comments getXpathComments();

    public abstract void setXpathComments(XPathParts.Comments var1);

    @Override
    public abstract Iterator<String> iterator();

    public Iterator<String> iterator(String prefix) {
        if (prefix == null || prefix.isEmpty()) {
            return this.iterator();
        }
        return Iterators.filter(this.iterator(), s2 -> s2.startsWith(prefix));
    }

    public Iterator<String> iterator(Matcher pathFilter) {
        if (pathFilter == null) {
            return this.iterator();
        }
        return Iterators.filter(this.iterator(), s2 -> pathFilter.reset((CharSequence)s2).matches());
    }

    public boolean isResolving() {
        return false;
    }

    public XMLSource getUnresolving() {
        return this;
    }

    @Override
    public XMLSource cloneAsThawed() {
        try {
            XMLSource result = (XMLSource)super.clone();
            result.locked = false;
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError("should never happen");
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (String path : this) {
            String value = this.getValueAtDPath(path);
            String fullpath = this.getFullPathAtDPath(path);
            result.append(fullpath).append(" =\t ").append(value).append("\n");
        }
        return result.toString();
    }

    public String toString(String regex) {
        Matcher matcher = PatternCache.get(regex).matcher("");
        StringBuilder result = new StringBuilder();
        Iterator<String> it = this.iterator(matcher);
        while (it.hasNext()) {
            String path = it.next();
            String value = this.getValueAtDPath(path);
            String fullpath = this.getFullPathAtDPath(path);
            result.append(fullpath).append(" =\t ").append(value).append("\n");
        }
        return result.toString();
    }

    public boolean isNonInheriting() {
        return this.nonInheriting;
    }

    public void setNonInheriting(boolean nonInheriting) {
        if (this.locked) {
            throw new UnsupportedOperationException("Attempt to modify locked object");
        }
        this.nonInheriting = nonInheriting;
    }

    public boolean isWinningPath(String path) {
        return this.getWinningPath(path).equals(path);
    }

    public String getWinningPath(String path) {
        String value;
        String newPath = CLDRFile.getNondraftNonaltXPath(path);
        if (!newPath.equals(path) && (value = this.getValueAtPath(newPath)) != null) {
            return newPath;
        }
        return path;
    }

    public void addListener(Listener listener) {
        this.listeners.add(new WeakReference<Listener>(listener));
    }

    public void notifyListeners(String xpath) {
        int i = 0;
        while (i < this.listeners.size()) {
            Listener listener = (Listener)this.listeners.get(i).get();
            if (listener == null) {
                this.listeners.remove(i);
                continue;
            }
            listener.valueChanged(xpath, this);
            ++i;
        }
    }

    public boolean isHere(String path) {
        return this.getValueAtPath(path) != null;
    }

    public abstract void getPathsWithValue(String var1, String var2, Set<String> var3);

    public VersionInfo getDtdVersionInfo() {
        return null;
    }

    public String getBaileyValue(String xpath, Output<String> pathWhereFound, Output<String> localeWhereFound) {
        return null;
    }

    public DtdType getDtdType() {
        Iterator<String> it = this.iterator();
        if (it.hasNext()) {
            String path = it.next();
            return DtdType.fromPath(path);
        }
        return null;
    }

    public DtdType getXMLNormalizingDtdType() {
        return this.XMLNormalizingDtdType;
    }

    public void setXMLNormalizingDtdType(DtdType dtdType) {
        this.XMLNormalizingDtdType = dtdType;
    }

    public XMLSource setInitialComment(String comment) {
        if (this.locked) {
            throw new UnsupportedOperationException("Attempt to modify locked object");
        }
        Log.logln(false, "SET initial Comment: \t" + comment);
        this.getXpathComments().setInitialComment(comment);
        return this;
    }

    public XMLSource addComment(String xpath, String comment, XPathParts.Comments.CommentType type) {
        if (this.locked) {
            throw new UnsupportedOperationException("Attempt to modify locked object");
        }
        Log.logln(false, "ADDING Comment: \t" + String.valueOf((Object)type) + "\t" + xpath + " \t" + comment);
        if (xpath == null || xpath.isEmpty()) {
            this.getXpathComments().setFinalComment(CldrUtility.joinWithSeparation(this.getXpathComments().getFinalComment(), "\n", comment));
        } else {
            xpath = CLDRFile.getDistinguishingXPath(xpath, null);
            this.getXpathComments().addComment(type, xpath, comment);
        }
        return this;
    }

    public String getFullXPath(String xpath) {
        if (xpath == null) {
            throw new NullPointerException("Null distinguishing xpath");
        }
        String result = this.getFullPath(xpath);
        return result != null ? result : xpath;
    }

    public XMLSource add(String currentFullXPath, String value) {
        if (this.locked) {
            throw new UnsupportedOperationException("Attempt to modify locked object");
        }
        Log.logln(false, "ADDING: \t" + currentFullXPath + " \t" + value + "\t" + currentFullXPath);
        try {
            this.putValueAtPath(currentFullXPath.intern(), value);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("failed adding " + currentFullXPath + ",\t" + value, e);
        }
        return this;
    }

    public static XMLSource getFrozenInstance(String localeId, List<File> dirs, CLDRFile.DraftStatus minimalDraftStatus) {
        return XMLNormalizingLoader.getFrozenInstance(localeId, dirs, minimalDraftStatus);
    }

    public XMLSource addSourceLocation(String currentFullXPath, SourceLocation location) {
        return this;
    }

    public SourceLocation getSourceLocation(String fullXPath) {
        return null;
    }

    public static class ResolvingSource
    extends XMLSource
    implements Listener {
        private final XMLSource currentSource;
        private final LinkedHashMap<String, XMLSource> sources;
        public static final boolean TRACE_VALUE = CldrUtility.getProperty("TRACE_VALUE", false);
        Map<String, String> getFullPathAtDPathCache = new HashMap<String, String>();
        private final transient Map<String, AliasLocation> getSourceLocaleIDCache = new WeakHashMap<String, AliasLocation>();
        static final Pattern COUNT_EQUALS = PatternCache.get("\\[@count=\"[^\"]*\"]");
        static final boolean TRACE_FILL = CldrUtility.getProperty("TRACE_FILL", false);
        static final String DEBUG_PATH_STRING = CldrUtility.getProperty("DEBUG_PATH", null);
        static final Pattern DEBUG_PATH = DEBUG_PATH_STRING == null ? null : PatternCache.get(DEBUG_PATH_STRING);
        static final boolean SKIP_FALLBACKID = CldrUtility.getProperty("SKIP_FALLBACKID", false);
        static final int MAX_LEVEL = 40;
        private transient Set<String> cachedKeySet = null;

        @Override
        public boolean isResolving() {
            return true;
        }

        @Override
        public XMLSource getUnresolving() {
            return this.sources.get(this.getLocaleID());
        }

        @Override
        public String getValueAtDPath(String xpath) {
            if (DEBUG_PATH != null && DEBUG_PATH.matcher(xpath).find()) {
                System.out.println("Getting value for Path: " + xpath);
            }
            if (TRACE_VALUE) {
                System.out.println("\t*xpath: " + xpath + "\n\t*source: " + this.currentSource.getClass().getName() + "\n\t*locale: " + this.currentSource.getLocaleID());
            }
            String result = null;
            AliasLocation fullStatus = this.getCachedFullStatus(xpath, true, null);
            if (fullStatus != null) {
                if (TRACE_VALUE) {
                    System.out.println("\t*pathWhereFound: " + fullStatus.pathWhereFound);
                    System.out.println("\t*localeWhereFound: " + fullStatus.localeWhereFound);
                }
                result = this.getSource(fullStatus).getValueAtDPath(fullStatus.pathWhereFound);
            }
            if (TRACE_VALUE) {
                System.out.println("\t*value: " + result);
            }
            return result;
        }

        @Override
        public SourceLocation getSourceLocation(String xpath) {
            SourceLocation result = null;
            String dPath = CLDRFile.getDistinguishingXPath(xpath, null);
            AliasLocation fullStatus = this.getCachedFullStatus(dPath, true, null);
            if (fullStatus != null) {
                result = this.getSource(fullStatus).getSourceLocation(xpath);
            }
            return result;
        }

        public XMLSource getSource(AliasLocation fullStatus) {
            XMLSource source = this.sources.get(fullStatus.localeWhereFound);
            return source == null ? CodeFallback.getConstructedItems() : source;
        }

        @Override
        public String getFullPathAtDPath(String xpath) {
            String fullPathWhereFound;
            String result = this.currentSource.getFullPathAtDPath(xpath);
            if (result != null) {
                return result;
            }
            AliasLocation fullStatus = this.getCachedFullStatus(xpath, true, null);
            if (fullStatus != null && (fullPathWhereFound = this.getSource(fullStatus).getFullPathAtDPath(fullStatus.pathWhereFound)) != null) {
                result = fullPathWhereFound.equals(fullStatus.pathWhereFound) ? xpath : this.getFullPath(xpath, fullStatus, fullPathWhereFound);
            }
            return result;
        }

        @Override
        public Date getChangeDateAtDPath(String xpath) {
            Date result = this.currentSource.getChangeDateAtDPath(xpath);
            if (result != null) {
                return result;
            }
            AliasLocation fullStatus = this.getCachedFullStatus(xpath, true, null);
            if (fullStatus != null) {
                result = this.getSource(fullStatus).getChangeDateAtDPath(fullStatus.pathWhereFound);
            }
            return result;
        }

        private String getFullPath(String xpath, AliasLocation fullStatus, String fullPathWhereFound) {
            String result = null;
            xpath = xpath.intern();
            if (this.cachingIsEnabled) {
                result = this.getFullPathAtDPathCache.get(xpath);
            }
            if (result == null) {
                XPathParts xpathParts = XPathParts.getFrozenInstance(xpath).cloneAsThawed();
                XPathParts fullPathWhereFoundParts = XPathParts.getFrozenInstance(fullPathWhereFound);
                XPathParts pathWhereFoundParts = XPathParts.getFrozenInstance(fullStatus.pathWhereFound);
                int offset = xpathParts.size() - pathWhereFoundParts.size();
                for (int i = 0; i < pathWhereFoundParts.size(); ++i) {
                    Map<String, String> fullAttributes = fullPathWhereFoundParts.getAttributes(i);
                    Map<String, String> attributes = pathWhereFoundParts.getAttributes(i);
                    if (attributes.equals(fullAttributes)) continue;
                    for (String key : fullAttributes.keySet()) {
                        if (attributes.containsKey(key)) continue;
                        String value = fullAttributes.get(key);
                        xpathParts.putAttributeValue(i + offset, key, value);
                    }
                }
                result = xpathParts.toString();
                if (this.cachingIsEnabled) {
                    this.getFullPathAtDPathCache.put(xpath, result);
                }
            }
            return result;
        }

        @Override
        public String getBaileyValue(String xpath, Output<String> pathWhereFound, Output<String> localeWhereFound) {
            AliasLocation fullStatus = this.getPathLocation(xpath, true, true, null);
            if (localeWhereFound != null) {
                localeWhereFound.value = fullStatus.localeWhereFound;
            }
            if (pathWhereFound != null) {
                pathWhereFound.value = fullStatus.pathWhereFound;
            }
            return this.getSource(fullStatus).getValueAtDPath(fullStatus.pathWhereFound);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private AliasLocation getCachedFullStatus(String xpath, boolean skipInheritanceMarker, List<LocaleInheritanceInfo> list) {
            if (!skipInheritanceMarker || !this.cachingIsEnabled || list != null) {
                return this.getPathLocation(xpath, false, skipInheritanceMarker, list);
            }
            Map<String, AliasLocation> map = this.getSourceLocaleIDCache;
            synchronized (map) {
                AliasLocation fullStatus = this.getSourceLocaleIDCache.get(xpath);
                if (fullStatus == null) {
                    fullStatus = this.getPathLocation(xpath, false, true, null);
                    this.getSourceLocaleIDCache.put(xpath, fullStatus);
                }
                return fullStatus;
            }
        }

        @Override
        public String getWinningPath(String xpath) {
            String result = this.currentSource.getWinningPath(xpath);
            if (result != null) {
                return result;
            }
            AliasLocation fullStatus = this.getCachedFullStatus(xpath, true, null);
            result = fullStatus != null ? this.getSource(fullStatus).getWinningPath(fullStatus.pathWhereFound) : xpath;
            return result;
        }

        @Override
        public String getSourceLocaleID(String distinguishedXPath, CLDRFile.Status status) {
            return this.getSourceLocaleIdExtended(distinguishedXPath, status, true, null);
        }

        @Override
        public String getSourceLocaleIdExtended(String distinguishedXPath, CLDRFile.Status status, boolean skipInheritanceMarker, List<LocaleInheritanceInfo> list) {
            AliasLocation fullStatus = this.getCachedFullStatus(distinguishedXPath, skipInheritanceMarker, list);
            if (status != null) {
                status.pathWhereFound = fullStatus.pathWhereFound;
            }
            return fullStatus.localeWhereFound;
        }

        private AliasLocation getPathLocation(String xpath, boolean skipFirst, boolean skipInheritanceMarker, List<LocaleInheritanceInfo> list) {
            xpath = xpath.intern();
            AliasLocation firstValue = null;
            for (XMLSource source : this.sources.values()) {
                if (skipFirst) {
                    skipFirst = false;
                    continue;
                }
                String value = source.getValueAtDPath(xpath);
                String localeID = source.getLocaleID();
                if (value != null) {
                    if (skipInheritanceMarker && CldrUtility.INHERITANCE_MARKER.equals(value)) {
                        if (list == null) continue;
                        list.add(new LocaleInheritanceInfo(localeID, xpath, LocaleInheritanceInfo.Reason.inheritanceMarker));
                        continue;
                    }
                    if (list == null) {
                        return new AliasLocation(xpath, localeID);
                    }
                    if (CldrUtility.INHERITANCE_MARKER.equals(value)) {
                        list.add(new LocaleInheritanceInfo(localeID, xpath, LocaleInheritanceInfo.Reason.inheritanceMarker));
                    } else {
                        list.add(new LocaleInheritanceInfo(localeID, xpath, LocaleInheritanceInfo.Reason.value));
                    }
                    if (firstValue != null) continue;
                    firstValue = new AliasLocation(xpath, localeID);
                    continue;
                }
                if (list == null) continue;
                list.add(new LocaleInheritanceInfo(localeID, xpath, LocaleInheritanceInfo.Reason.none));
            }
            String rootAliasLocale = XMLSource.ROOT_ID;
            TreeMap<String, String> aliases = this.sources.get(XMLSource.ROOT_ID).getAliases();
            Object aliasedPath = aliases.get(xpath);
            if (aliasedPath == null) {
                String possibleSubpath = aliases.lowerKey(xpath);
                if (possibleSubpath != null && xpath.startsWith(possibleSubpath)) {
                    aliasedPath = aliases.get(possibleSubpath) + xpath.substring(possibleSubpath.length());
                    aliasedPath = ((String)aliasedPath).intern();
                    if (list != null) {
                        list.add(new LocaleInheritanceInfo(XMLSource.ROOT_ID, (String)aliasedPath, LocaleInheritanceInfo.Reason.alias));
                    }
                }
            } else if (list != null) {
                list.add(new LocaleInheritanceInfo(XMLSource.ROOT_ID, (String)aliasedPath, LocaleInheritanceInfo.Reason.alias));
            }
            if (aliasedPath == null && xpath.contains("[@alt=")) {
                aliasedPath = XPathParts.getPathWithoutAlt(xpath).intern();
                if (list != null) {
                    list.add(new LocaleInheritanceInfo(null, (String)aliasedPath, LocaleInheritanceInfo.Reason.removedAttribute, "alt"));
                }
            }
            if (aliasedPath == null && xpath.contains("[@count=")) {
                aliasedPath = COUNT_EQUALS.matcher(xpath).replaceAll("[@count=\"other\"]").intern();
                if (((String)aliasedPath).equals(xpath)) {
                    if (xpath.contains("/displayName")) {
                        aliasedPath = COUNT_EQUALS.matcher(xpath).replaceAll("").intern();
                        if (((String)aliasedPath).equals(xpath)) {
                            throw new RuntimeException("Internal error");
                        }
                    } else {
                        aliasedPath = null;
                    }
                }
                if (list != null && aliasedPath != null) {
                    list.add(new LocaleInheritanceInfo(null, (String)aliasedPath, LocaleInheritanceInfo.Reason.changedAttribute, "count"));
                }
            }
            if (aliasedPath != null) {
                AliasLocation cachedFullStatus = this.getCachedFullStatus((String)aliasedPath, skipInheritanceMarker, list);
                if (firstValue == null) {
                    return cachedFullStatus;
                }
                return firstValue;
            }
            if (list != null) {
                list.add(new LocaleInheritanceInfo(null, xpath, LocaleInheritanceInfo.Reason.codeFallback));
            }
            if (firstValue == null) {
                return new AliasLocation(xpath, XMLSource.CODE_FALLBACK_ID);
            }
            return firstValue;
        }

        private Set<String> fillKeys() {
            boolean newPathsFound;
            Set<String> paths;
            Set<String> newPaths = paths = this.findNonAliasedPaths();
            int level = 0;
            do {
                if (TRACE_FILL && DEBUG_PATH == null || level > 40) {
                    System.out.println(Utility.repeat(XMLSource.TRACE_INDENT, level) + "# paths waiting to be aliased: " + newPaths.size());
                    System.out.println(Utility.repeat(XMLSource.TRACE_INDENT, level) + "# paths found: " + paths.size());
                }
                if (level > 40) {
                    throw new IllegalArgumentException("Stack overflow");
                }
                Object[] sortedPaths = new String[newPaths.size()];
                newPaths.toArray(sortedPaths);
                Arrays.sort(sortedPaths);
                newPaths = this.getDirectAliases((String[])sortedPaths);
                newPathsFound = paths.addAll(newPaths);
                ++level;
            } while (newPathsFound);
            return paths;
        }

        private Set<String> findNonAliasedPaths() {
            HashSet<String> paths = new HashSet<String>();
            ArrayList<XMLSource> sourceList = new ArrayList<XMLSource>(this.sources.values());
            if (!SKIP_FALLBACKID) {
                sourceList.add(CodeFallback.getConstructedItems());
            }
            for (XMLSource curSource : sourceList) {
                for (String xpath : curSource) {
                    paths.add(xpath.intern());
                }
            }
            return paths;
        }

        private Set<String> getDirectAliases(String[] paths) {
            HashSet<String> newPaths = new HashSet<String>();
            int pathIndex = 0;
            LinkedHashMap<String, List<String>> reverseAliases = this.getReverseAliases();
            for (String subpath : reverseAliases.keySet()) {
                String xpath;
                int endIndex;
                while (pathIndex < paths.length && paths[pathIndex].compareTo(subpath) < 0) {
                    ++pathIndex;
                }
                List<String> list = reverseAliases.get(subpath);
                int suffixStart = subpath.length();
                for (endIndex = pathIndex; endIndex < paths.length && (xpath = paths[endIndex]).startsWith(subpath) && xpath.charAt(suffixStart) == '/'; ++endIndex) {
                    String suffix = xpath.substring(suffixStart);
                    for (String reverseAlias : list) {
                        String reversePath = reverseAlias + suffix;
                        newPaths.add(reversePath.intern());
                    }
                }
                if (endIndex != paths.length) continue;
                break;
            }
            return newPaths;
        }

        @Override
        private LinkedHashMap<String, List<String>> getReverseAliases() {
            return this.sources.get(XMLSource.ROOT_ID).getReverseAliases();
        }

        @Override
        public Iterator<String> iterator() {
            return this.getCachedKeySet().iterator();
        }

        private Set<String> getCachedKeySet() {
            if (this.cachedKeySet == null) {
                this.cachedKeySet = this.fillKeys();
                this.cachedKeySet = Collections.unmodifiableSet(this.cachedKeySet);
            }
            return this.cachedKeySet;
        }

        @Override
        public void putFullPathAtDPath(String distinguishingXPath, String fullxpath) {
            throw new UnsupportedOperationException("Resolved CLDRFiles are read-only");
        }

        @Override
        public void putValueAtDPath(String distinguishingXPath, String value) {
            throw new UnsupportedOperationException("Resolved CLDRFiles are read-only");
        }

        @Override
        public XPathParts.Comments getXpathComments() {
            return this.currentSource.getXpathComments();
        }

        @Override
        public void setXpathComments(XPathParts.Comments path) {
            throw new UnsupportedOperationException("Resolved CLDRFiles are read-only");
        }

        @Override
        public void removeValueAtDPath(String xpath) {
            throw new UnsupportedOperationException("Resolved CLDRFiles are  read-only");
        }

        @Override
        public XMLSource freeze() {
            return this;
        }

        @Override
        public boolean isFrozen() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void valueChanged(String xpath, XMLSource nonResolvingSource) {
            if (!this.cachingIsEnabled) {
                return;
            }
            Map<String, AliasLocation> map = this.getSourceLocaleIDCache;
            synchronized (map) {
                AliasLocation location = this.getSourceLocaleIDCache.remove(xpath);
                if (location == null) {
                    return;
                }
                Set<String> dependentPaths = this.getDirectAliases(new String[]{xpath});
                if (!dependentPaths.isEmpty()) {
                    for (String path : dependentPaths) {
                        this.getSourceLocaleIDCache.remove(path);
                    }
                }
            }
        }

        public ResolvingSource(List<XMLSource> sourceList) {
            if (sourceList == null || !sourceList.get(sourceList.size() - 1).getLocaleID().equals(XMLSource.ROOT_ID)) {
                throw new IllegalArgumentException("Last element should be root");
            }
            this.currentSource = sourceList.get(0);
            this.sources = new LinkedHashMap();
            for (XMLSource source : sourceList) {
                this.sources.put(source.getLocaleID(), source);
            }
            int limit = sourceList.size() - 1;
            for (int i = 0; i < limit; ++i) {
                sourceList.get(i).addListener(this);
            }
        }

        @Override
        public String getLocaleID() {
            return this.currentSource.getLocaleID();
        }

        @Override
        public boolean isHere(String path) {
            return this.currentSource.isHere(path);
        }

        @Override
        public void getPathsWithValue(String valueToMatch, String pathPrefix, Set<String> result) {
            Set<String> newAliases;
            ArrayList<XMLSource> children = new ArrayList<XMLSource>();
            HashSet<String> filteredPaths = new HashSet<String>();
            for (XMLSource source : this.sources.values()) {
                HashSet<String> pathsWithValue = new HashSet<String>();
                source.getPathsWithValue(valueToMatch, pathPrefix, pathsWithValue);
                for (String pathWithValue : pathsWithValue) {
                    if (this.sourcesHavePath(pathWithValue, children)) continue;
                    filteredPaths.add(pathWithValue);
                }
                children.add(source);
            }
            HashSet<String> aliases = new HashSet<String>();
            Set<Object> oldAliases = new HashSet(filteredPaths);
            do {
                Object[] sortedPaths = new String[oldAliases.size()];
                oldAliases.toArray(sortedPaths);
                Arrays.sort(sortedPaths);
                newAliases = this.getDirectAliases((String[])sortedPaths);
                oldAliases = newAliases;
                aliases.addAll(newAliases);
            } while (!newAliases.isEmpty());
            String norm = null;
            for (String alias : aliases) {
                String value;
                if (!alias.startsWith(pathPrefix)) continue;
                if (norm == null && valueToMatch != null) {
                    norm = SimpleXMLSource.normalize(valueToMatch);
                }
                if ((value = this.getValueAtDPath(alias)) == null || !SimpleXMLSource.normalize(value).equals(norm)) continue;
                filteredPaths.add(alias);
            }
            result.addAll(filteredPaths);
        }

        private boolean sourcesHavePath(String xpath, List<XMLSource> sources) {
            for (XMLSource source : sources) {
                if (!source.hasValueAtDPath(xpath)) continue;
                return true;
            }
            return false;
        }

        @Override
        public VersionInfo getDtdVersionInfo() {
            return this.currentSource.getDtdVersionInfo();
        }
    }

    public static final class Alias {
        private final String newLocaleID;
        private final String oldPath;
        private final String newPath;
        static final Pattern aliasPattern = Pattern.compile("(?:\\[@source=\"([^\"]*)\"])?(?:\\[@path=\"([^\"]*)\"])?(?:\\[@draft=\"([^\"]*)\"])?");
        static final Pattern MIDDLE_OF_ATTRIBUTE_VALUE = PatternCache.get("[^\"]*\"\\]");

        public static Alias make(String aliasPath) {
            int pos = aliasPath.indexOf("/alias");
            if (pos < 0) {
                return null;
            }
            String aliasParts = aliasPath.substring(pos + 6);
            String oldPath = aliasPath.substring(0, pos);
            return new Alias(oldPath, null, aliasParts);
        }

        private Alias(String oldPath, String newPath, String aliasParts) {
            boolean pathsEqual;
            Matcher matcher = aliasPattern.matcher(aliasParts);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("bad alias pattern for " + aliasParts);
            }
            String newLocaleID = matcher.group(1);
            if (newLocaleID != null && newLocaleID.equals("locale")) {
                newLocaleID = null;
            }
            String relativePath2 = matcher.group(2);
            if (newPath == null) {
                newPath = oldPath;
            }
            if (relativePath2 != null) {
                newPath = Alias.addRelative(newPath, relativePath2);
            }
            if ((pathsEqual = oldPath.equals(newPath)) && newLocaleID == null) {
                throw new IllegalArgumentException("Alias must have different path or different source. AliasPath: " + aliasParts + ", Alias: " + newPath + ", " + newLocaleID);
            }
            this.newLocaleID = newLocaleID;
            this.oldPath = oldPath;
            this.newPath = newPath;
        }

        static String addRelative(String oldPath, String relativePath) {
            if (relativePath.startsWith("//")) {
                return relativePath;
            }
            while (relativePath.startsWith("../")) {
                relativePath = relativePath.substring(3);
                while (relativePath.startsWith("/")) {
                    relativePath = relativePath.substring(1);
                }
                oldPath = Alias.stripLastElement(oldPath);
            }
            return oldPath + "/" + relativePath.replace('\'', '\"');
        }

        public static String stripLastElement(String oldPath) {
            int oldPos = oldPath.lastIndexOf(47);
            Matcher verifyElement = MIDDLE_OF_ATTRIBUTE_VALUE.matcher(oldPath.substring(oldPos));
            while (verifyElement.lookingAt()) {
                oldPos = oldPath.lastIndexOf(47, oldPos - 1);
                verifyElement.reset(oldPath.substring(oldPos));
            }
            oldPath = oldPath.substring(0, oldPos);
            return oldPath;
        }

        public String toString() {
            return "newLocaleID: " + this.newLocaleID + ",\toldPath: " + this.oldPath + ",\n\tnewPath: " + this.newPath;
        }

        public String getOldPath() {
            return this.oldPath;
        }

        public String getNewPath() {
            return this.newPath;
        }

        public static boolean isAliasPath(String path) {
            return path.contains("/alias");
        }
    }

    public static interface Listener {
        public void valueChanged(String var1, XMLSource var2);
    }

    public static class AliasLocation {
        public final String pathWhereFound;
        public final String localeWhereFound;

        public AliasLocation(String pathWhereFound, String localeWhereFound) {
            this.pathWhereFound = pathWhereFound;
            this.localeWhereFound = localeWhereFound;
        }
    }

    public static class SourceLocation {
        static final String FILE_PREFIX = "file://";
        private final String system;
        private final int line;
        private final int column;

        public SourceLocation(Locator locator) {
            this(locator.getSystemId(), locator.getLineNumber(), locator.getColumnNumber());
        }

        public SourceLocation(String system, int line, int column) {
            this.system = system.intern();
            this.line = line;
            this.column = column;
        }

        public String getSystem() {
            if (this.system.startsWith(FILE_PREFIX)) {
                return this.system.substring(FILE_PREFIX.length());
            }
            return this.system;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }

        public String toString() {
            return this.toString(null);
        }

        public String toString(String basePath) {
            return this.getSystem(basePath) + ":" + this.getLine() + ":" + this.getColumn() + ": ";
        }

        public String forGitHub(String basePath) {
            return "file=" + this.getSystem(basePath) + ",line=" + this.getLine() + ",col=" + this.getColumn();
        }

        public String getSystem(String basePath) {
            String path = this.getSystem();
            if (basePath != null && !basePath.isEmpty() && path.startsWith(basePath) && (path = path.substring(basePath.length())).startsWith("/") && !basePath.endsWith("/")) {
                path = path.substring(1);
            }
            return path;
        }
    }
}

