/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util.fixedcandidates;

import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;
import org.unicode.cldr.util.CLDRLocale;
import org.unicode.cldr.util.GrammarInfo;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.fixedcandidates.FixedCandidateProvider;

class GrammarCandidateProviders {
    private static final String XPATH_PATTERN = "^//ldml/units/unitLength.*/unit.*gender";
    static final SupplementalDataInfo sdi = SupplementalDataInfo.getInstance();
    static final Pattern pattern = PatternCache.get("^//ldml/units/unitLength.*/unit.*gender");

    GrammarCandidateProviders() {
    }

    public static final FixedCandidateProvider forLocale(CLDRLocale locale) {
        GrammarInfo grammarInfo = sdi.getGrammarInfo(locale.getBaseName());
        if (grammarInfo == null) {
            return FixedCandidateProvider.forXPathPattern(pattern, Collections.emptyList());
        }
        Collection<String> candidates = grammarInfo.get(GrammarInfo.GrammaticalTarget.nominal, GrammarInfo.GrammaticalFeature.grammaticalGender, GrammarInfo.GrammaticalScope.units);
        return FixedCandidateProvider.forXPathPattern(pattern, candidates);
    }
}

