/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util.personname;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.ibm.icu.util.ULocale;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.personname.PersonNameFormatter;

public class SimpleNameObject
implements PersonNameFormatter.NameObject {
    private final ULocale nameLocale;
    private final Map<PersonNameFormatter.Field, Map<Set<PersonNameFormatter.Modifier>, String>> patternData;
    private ImmutableMap<PersonNameFormatter.ModifiedField, String> modifiedFieldToValue;

    @Override
    public Set<PersonNameFormatter.Field> getAvailableFields() {
        return this.patternData.keySet();
    }

    @Override
    public ImmutableMap<PersonNameFormatter.ModifiedField, String> getModifiedFieldToValue() {
        return this.modifiedFieldToValue;
    }

    @Override
    public String getBestValue(PersonNameFormatter.ModifiedField modifiedField, Set<PersonNameFormatter.Modifier> remainingModifers) {
        Set<PersonNameFormatter.Modifier> modifiers = modifiedField.getModifiers();
        remainingModifers.clear();
        remainingModifers.addAll(modifiers);
        Map<Set<PersonNameFormatter.Modifier>, String> fieldData = this.patternData.get((Object)modifiedField.getField());
        if (fieldData == null) {
            return null;
        }
        Set<Map.Entry<Set<PersonNameFormatter.Modifier>, String>> fieldDataEntries = fieldData.entrySet();
        if (fieldDataEntries.size() == 1) {
            return fieldDataEntries.iterator().next().getValue();
        }
        String bestValue = null;
        Set<Object> bestModifiers = ImmutableSet.of();
        String lastValue = null;
        int largestIntersectionSize = -1;
        for (Map.Entry<Set<PersonNameFormatter.Modifier>, String> entry : fieldDataEntries) {
            lastValue = entry.getValue();
            Set<PersonNameFormatter.Modifier> dataModifiers = entry.getKey();
            if (dataModifiers.size() <= largestIntersectionSize) break;
            int intersectionSize = PersonNameFormatter.getIntersectionSize(dataModifiers, modifiers);
            if (intersectionSize == 0 || intersectionSize <= largestIntersectionSize) continue;
            bestValue = lastValue;
            bestModifiers = dataModifiers;
            largestIntersectionSize = intersectionSize;
        }
        remainingModifers.removeAll(bestModifiers);
        return bestValue == null ? lastValue : bestValue;
    }

    @Override
    public ULocale getNameLocale() {
        return this.nameLocale;
    }

    public SimpleNameObject(ULocale nameLocale, Map<PersonNameFormatter.ModifiedField, String> patternData) {
        PersonNameFormatter.Field field;
        this.nameLocale = nameLocale == null ? ULocale.ROOT : nameLocale;
        this.modifiedFieldToValue = ImmutableMap.copyOf(patternData);
        EnumMap<PersonNameFormatter.Field, Map<Set<PersonNameFormatter.Modifier>, String>> _patternData = new EnumMap<PersonNameFormatter.Field, Map<Set<PersonNameFormatter.Modifier>, String>>(PersonNameFormatter.Field.class);
        for (Map.Entry<PersonNameFormatter.ModifiedField, String> entry : patternData.entrySet()) {
            PersonNameFormatter.ModifiedField modifiedField = entry.getKey();
            field = modifiedField.getField();
            Set<PersonNameFormatter.Modifier> modifiers = modifiedField.getModifiers();
            String value = entry.getValue();
            this.putChain(_patternData, field, modifiers, value);
        }
        EnumMap<PersonNameFormatter.Field, Map<Set<PersonNameFormatter.Modifier>, String>> additions = null;
        for (Map.Entry entry : _patternData.entrySet()) {
            String coreValue;
            Map map = (Map)entry.getValue();
            if (map.get(PersonNameFormatter.Modifier.EMPTY) != null || (coreValue = (String)map.get(ImmutableSet.of(PersonNameFormatter.Modifier.core))) == null) continue;
            if (additions == null) {
                additions = new EnumMap<PersonNameFormatter.Field, Map<Set<PersonNameFormatter.Modifier>, String>>(PersonNameFormatter.Field.class);
            }
            String prefixValue = (String)map.get(ImmutableSet.of(PersonNameFormatter.Modifier.prefix));
            PersonNameFormatter.Field field2 = (PersonNameFormatter.Field)((Object)entry.getKey());
            this.putChain(additions, field2, PersonNameFormatter.Modifier.EMPTY, (String)(prefixValue == null ? coreValue : prefixValue + " " + coreValue));
        }
        if (additions != null) {
            for (Map.Entry entry : additions.entrySet()) {
                field = (PersonNameFormatter.Field)((Object)entry.getKey());
                for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                    this.putChain(_patternData, field, (Set)entry2.getKey(), (String)entry2.getValue());
                }
            }
        }
        this.patternData = CldrUtility.protectCollection(_patternData);
    }

    private void putChain(Map<PersonNameFormatter.Field, Map<Set<PersonNameFormatter.Modifier>, String>> _patternData, PersonNameFormatter.Field field, Set<PersonNameFormatter.Modifier> modifiers, String value) {
        Map<Set<PersonNameFormatter.Modifier>, String> fieldData = _patternData.get((Object)field);
        if (fieldData == null) {
            fieldData = new TreeMap<Collection<PersonNameFormatter.Modifier>, String>(PersonNameFormatter.Modifier.LONGEST_FIRST);
            _patternData.put(field, fieldData);
        }
        fieldData.put(modifiers, value);
    }

    public static SimpleNameObject from(String namePattern) {
        return SimpleNameObject.from(',', namePattern);
    }

    public static SimpleNameObject from(char separator, String namePattern) {
        LinkedHashMap<PersonNameFormatter.ModifiedField, String> patternData = new LinkedHashMap<PersonNameFormatter.ModifiedField, String>();
        ULocale nameLocale = ULocale.ROOT;
        block6: for (String setting : Splitter.on(separator).trimResults().split(namePattern)) {
            List<String> parts = PersonNameFormatter.SPLIT_EQUALS.splitToList(setting);
            if (parts.size() != 2) {
                throw new IllegalArgumentException("Bad format, should be like: given=John Bob, given2=Edwin, \u2026: " + namePattern);
            }
            String key = parts.get(0);
            String value = parts.get(1);
            switch (key) {
                case "locale": {
                    nameLocale = new ULocale(value);
                    continue block6;
                }
            }
            patternData.put(PersonNameFormatter.ModifiedField.from(key), value);
        }
        return new SimpleNameObject(nameLocale, patternData);
    }

    public String toString() {
        return "{locale=" + String.valueOf(this.nameLocale) + " patternData=" + SimpleNameObject.show(this.patternData) + "}";
    }

    public static String show(Map<PersonNameFormatter.Field, Map<Set<PersonNameFormatter.Modifier>, String>> patternData2) {
        return SimpleNameObject.show(patternData2, ShowStyle.toString);
    }

    public static String show(Map<PersonNameFormatter.Field, Map<Set<PersonNameFormatter.Modifier>, String>> patternData2, ShowStyle showStyle) {
        StringBuilder sb = new StringBuilder(showStyle.start);
        boolean first = true;
        for (Map.Entry<PersonNameFormatter.Field, Map<Set<PersonNameFormatter.Modifier>, String>> entry : patternData2.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(showStyle.middle);
            }
            sb.append((Object)entry.getKey()).append('=');
            Map<Set<PersonNameFormatter.Modifier>, String> map = entry.getValue();
            if (map.size() == 1) {
                sb.append(map.values().iterator().next());
                continue;
            }
            sb.append(map);
        }
        return sb.append(showStyle.end).toString();
    }

    public Map<PersonNameFormatter.Field, Map<Set<PersonNameFormatter.Modifier>, String>> getPatternData() {
        return this.patternData;
    }

    public static enum ShowStyle {
        toString("{", ", ", "}"),
        semicolon("", "; ", "");

        private final String start;
        private final String middle;
        private final String end;

        private ShowStyle(String start, String middle, String end) {
            this.start = start;
            this.middle = middle;
            this.end = end;
        }
    }
}

