/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.collect.ImmutableMap;
import com.ibm.icu.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.unicode.cldr.util.XPathValue;

public class SupplementalCalendarData
implements Iterable<String> {
    private Map<String, CalendarData> typeToCalendar = new HashMap<String, CalendarData>();

    private SupplementalCalendarData(Map<String, CalendarData> m4) {
        this.typeToCalendar = ImmutableMap.copyOf(m4);
    }

    public CalendarData get(String t2) {
        return this.typeToCalendar.get(t2);
    }

    @Override
    public Iterator<String> iterator() {
        return this.typeToCalendar.keySet().iterator();
    }

    static class Parser
    implements Consumer<XPathValue>,
    Supplier<SupplementalCalendarData> {
        private Map<String, CalendarData> typeToCalendar = new HashMap<String, CalendarData>();

        Parser() {
        }

        CalendarData getCalendar(String type) {
            return this.typeToCalendar.computeIfAbsent(type, ignored -> new CalendarData());
        }

        @Override
        public void accept(XPathValue x) {
            String level3;
            if (!x.getElement(2).equals("calendar")) {
                throw new UnsupportedOperationException("Unsupported supplemental xpath " + String.valueOf(x));
            }
            if (x.size() < 4) {
                return;
            }
            String calendarType = x.getAttributeValue(2, "type");
            if (calendarType == null || calendarType.isEmpty()) {
                throw new IllegalArgumentException("No calendar type on " + String.valueOf(x));
            }
            CalendarData c = this.getCalendar(calendarType);
            switch (level3 = x.getElement(3)) {
                case "calendarSystem": {
                    this.acceptCalendarSystem(x, c);
                    break;
                }
                case "inheritEras": {
                    this.acceptInheritEras(x, c);
                    break;
                }
                case "eras": {
                    this.acceptEras(x, c);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported supplemental xpath " + String.valueOf(x) + " got " + level3);
                }
            }
        }

        private void acceptEras(XPathValue x, CalendarData c) {
            if (x.size() < 5) {
                return;
            }
            if (x.size() > 5) {
                throw new IllegalArgumentException("Unsupported deep era xpath " + String.valueOf(x));
            }
            String e = x.getElement(4);
            if (!e.equals("era")) {
                throw new IllegalArgumentException("Unsupported era xpath " + String.valueOf(x));
            }
            String type = x.getAttributeValue(4, "type");
            if (type == null || type.isEmpty()) {
                throw new IllegalArgumentException("Bad calendar era, no biscuit " + String.valueOf(x));
            }
            Integer n = Integer.parseInt(type);
            if (c.eras.putIfAbsent(n, new EraData(x)) != null) {
                throw new IllegalArgumentException("Duplicate calendar era " + String.valueOf(x));
            }
        }

        private void acceptInheritEras(XPathValue x, CalendarData c) {
            if (c.inheritEras != null) {
                throw new IllegalArgumentException("Duplicate calendar inheritEras: " + String.valueOf(x));
            }
            c.inheritEras = x;
        }

        private void acceptCalendarSystem(XPathValue x, CalendarData c) {
            if (c.system != null) {
                throw new IllegalArgumentException("Duplicate calendar system: " + String.valueOf(x));
            }
            c.system = x;
        }

        @Override
        public SupplementalCalendarData get() {
            return new SupplementalCalendarData(this.typeToCalendar);
        }
    }

    public static class CalendarData
    implements Iterable<Integer> {
        static final int INDEX = 3;
        private XPathValue system = null;
        private XPathValue inheritEras = null;
        private Map<Integer, EraData> eras = new HashMap<Integer, EraData>();

        public String getSystemType() {
            if (this.system == null) {
                return null;
            }
            return this.system.getAttributeValue(3, "type");
        }

        public String getInheritEras() {
            if (this.inheritEras == null) {
                return null;
            }
            return this.inheritEras.getAttributeValue(3, "calendar");
        }

        @Override
        public Iterator<Integer> iterator() {
            return this.eras.keySet().iterator();
        }

        public EraData get(Integer era) {
            return this.eras.get(era);
        }
    }

    public static class EraData
    implements Comparable<EraData> {
        static final int INDEX = 4;
        private final XPathValue xpath;

        EraData(XPathValue xpath) {
            this.xpath = xpath;
        }

        public int getType() {
            return Integer.parseInt(this.xpath.getAttributeValue(4, "type"));
        }

        public String getStart() {
            return this.xpath.getAttributeValue(4, "start");
        }

        public String getEnd() {
            return this.xpath.getAttributeValue(4, "end");
        }

        public GregorianCalendar getStartCalendar() {
            return EraData.forDateString(this.getStart());
        }

        public GregorianCalendar getEndCalendar() {
            return EraData.forDateString(this.getEnd());
        }

        public String getCode() {
            return this.xpath.getAttributeValue(4, "code");
        }

        public String[] getAliases() {
            String s2 = this.xpath.getAttributeValue(4, "aliases");
            if (s2 == null) {
                return "".split(" ");
            }
            return s2.split(" ");
        }

        public String toString() {
            return String.format("ERA %d, [%s-%s] code=%s, aliases=%s", this.getType(), this.getStart(), this.getEnd(), this.getCode(), String.join((CharSequence)",", this.getAliases()));
        }

        private static final GregorianCalendar forDateString(String ymd) {
            if (ymd == null) {
                return null;
            }
            int multiplier = 1;
            if (ymd.startsWith("-")) {
                multiplier = -1;
                ymd = ymd.substring(1);
            }
            String[] parts = ymd.split("-");
            try {
                return new GregorianCalendar(multiplier * Integer.parseInt(parts[0]), Integer.parseInt(parts[1]) - 1, Integer.parseInt(parts[2]));
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("While parsing date string " + ymd, nfe);
            }
        }

        private GregorianCalendar getLatest() {
            GregorianCalendar l = this.getEndCalendar();
            if (l == null) {
                l = this.getStartCalendar();
            }
            return l;
        }

        @Override
        public int compareTo(EraData o) {
            GregorianCalendar l = this.getLatest();
            GregorianCalendar ol = o.getLatest();
            if (l == null || ol == null) {
                return Integer.compare(this.getType(), o.getType());
            }
            return l.compareTo(ol);
        }
    }
}

