/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.unicode.cldr.util.NodeListIterator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XPathExpressionParser {
    private final byte[] buf;

    private Document getDocument(InputStream is) throws SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            return dbf.newDocumentBuilder().parse(is);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public XPathExpressionParser(File f) throws IOException {
        this.buf = Files.readAllBytes(f.toPath());
    }

    public XPathExpressionParser(Reader rdr) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = new BufferedReader(rdr);){
            String s2 = null;
            while ((s2 = br.readLine()) != null) {
                sb.append(s2);
            }
        }
        this.buf = sb.toString().getBytes();
    }

    private void evaluateWithXPathFixture(String xPathString, QName expectedResult, boolean iterate, SimpleContentHandlingInterface handler) throws XPathExpressionException {
        if (handler != null) {
            try (BufferedInputStream is = new BufferedInputStream(new ByteArrayInputStream(this.buf));){
                Document doc = this.getDocument(is);
                XPathFactory xpFact = XPathFactory.newInstance();
                XPath xp = xpFact.newXPath();
                Object result = xp.compile(xPathString).evaluate(doc, expectedResult);
                if (expectedResult == XPathConstants.NODESET && iterate) {
                    if (result instanceof NodeList) {
                        NodeList nl = (NodeList)result;
                        NodeListIterator nlIter = new NodeListIterator(nl);
                        while (nlIter.hasNext()) {
                            handler.handle(nlIter.next());
                        }
                    }
                } else {
                    handler.handle(result);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
        }
    }

    public void evaluate(String xPathString, QName expectedResult, SimpleContentHandlingInterface<?> handler) throws XPathException {
        this.evaluateWithXPathFixture(xPathString, expectedResult, false, handler);
    }

    public void evaluateToNode(String xPathString, NodeHandlingInterface handler) throws XPathException {
        this.iterate(xPathString, XPathConstants.NODE, handler);
    }

    public void iterate(String xPathString, QName expectedReturnType, NodeHandlingInterface handler) throws XPathException {
        this.evaluateWithXPathFixture(xPathString, expectedReturnType, true, handler);
    }

    public void iterateThroughNodeSet(String xPathExpression, NodeHandlingInterface handler) throws XPathException {
        this.iterate(xPathExpression, XPathConstants.NODESET, handler);
    }

    public static interface NodeHandlingInterface
    extends SimpleContentHandlingInterface<Node> {
    }

    public static interface SimpleContentHandlingInterface<G> {
        public void handle(G var1);
    }
}

